/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Message;
import org.restlet.Response;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.engine.connector.ClientConnectionHelper;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionState;
import org.restlet.engine.connector.InboundWay;
import org.restlet.engine.connector.MessageState;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.io.IoState;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientInboundWay
extends InboundWay {
    public ClientInboundWay(Connection<?> connection) {
        super(connection);
    }

    protected void copyResponseTransportHeaders(Series<Parameter> headers, Response response) {
        HeaderUtils.copyResponseTransportHeaders(headers, response);
    }

    protected Status createStatus(int code) {
        return Status.valueOf(code);
    }

    @Override
    protected Message getActualMessage() {
        return this.getMessage();
    }

    public Connection<Client> getConnection() {
        return super.getConnection();
    }

    public ClientConnectionHelper getHelper() {
        return (ClientConnectionHelper)super.getHelper();
    }

    @Override
    protected int getSocketInterestOps() {
        int result = 0;
        result = this.getConnection().getState() == ConnectionState.OPENING ? 8 : super.getSocketInterestOps();
        return result;
    }

    @Override
    public void onCompleted(boolean endReached) {
        if (endReached || !this.getConnection().isPersistent() || HeaderUtils.isConnectionClose(this.getHeaders())) {
            this.getConnection().close(true);
        }
        super.onCompleted(endReached);
    }

    @Override
    protected void onReceived() {
        this.getMessage().setEntity(this.createEntity(this.getHeaders()));
        try {
            this.copyResponseTransportHeaders(this.getHeaders(), this.getMessage());
        }
        catch (Throwable t) {
            this.getLogger().log(Level.WARNING, "Error while parsing the headers", t);
        }
        if (this.getHeaders() != null) {
            this.getMessage().getAttributes().put("org.restlet.http.headers", this.getHeaders());
        }
        if (!this.getMessage().getStatus().isInformational()) {
            this.getMessages().poll();
        }
        this.getHelper().getInboundMessages().add(this.getMessage());
        if (this.getMessage().isEntityAvailable()) {
            this.setIoState(IoState.IDLE);
        } else {
            this.onCompleted(false);
        }
    }

    @Override
    protected void readStartLine() throws IOException {
        String version = null;
        int statusCode = -1;
        String reasonPhrase = null;
        int i = 0;
        int start = 0;
        int size = this.getLineBuilder().length();
        if (size != 0) {
            char next;
            for (i = start; version == null && i < size; ++i) {
                next = this.getLineBuilder().charAt(i);
                if (!HeaderUtils.isSpace(next)) continue;
                version = this.getLineBuilder().substring(start, i);
                start = i + 1;
            }
            for (i = start; statusCode == -1 && i < size; ++i) {
                next = this.getLineBuilder().charAt(i);
                if (!HeaderUtils.isSpace(next)) continue;
                try {
                    statusCode = Integer.parseInt(this.getLineBuilder().substring(start, i));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Unable to parse the status code. Non numeric value: " + this.getLineBuilder().substring(start, i).toString());
                }
                start = i + 1;
            }
            if (statusCode == -1) {
                throw new IOException("Unable to parse the status code. End of line reached too early.");
            }
            for (i = start; reasonPhrase == null && i < size; ++i) {
                next = this.getLineBuilder().charAt(i);
            }
            if (i == size) {
                reasonPhrase = this.getLineBuilder().substring(start, i);
                start = i + 1;
            }
            if (reasonPhrase == null) {
                throw new IOException("Unable to parse the reason phrase. End of line reached too early.");
            }
            Response finalResponse = this.getMessages().peek();
            Response response = null;
            Status status = this.createStatus(statusCode);
            response = status.isInformational() ? this.getHelper().createResponse(finalResponse.getRequest()) : finalResponse;
            response.setStatus(status, reasonPhrase);
            response.getServerInfo().setAddress(this.getConnection().getSocket().getLocalAddress().toString());
            response.getServerInfo().setAgent("Restlet-Framework/2.1m1");
            response.getServerInfo().setPort(this.getConnection().getSocket().getPort());
            this.setMessage(response);
            this.setMessageState(MessageState.HEADERS);
            this.clearLineBuilder();
        }
    }

    @Override
    public void updateState() {
        if (this.getIoState() == IoState.IDLE && !this.getMessages().isEmpty()) {
            this.setIoState(IoState.INTEREST);
        }
        super.updateState();
    }
}

