/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Message;
import org.restlet.Response;
import org.restlet.data.Parameter;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionHelper;
import org.restlet.engine.connector.ConnectionState;
import org.restlet.engine.connector.MessageState;
import org.restlet.engine.io.BufferState;
import org.restlet.engine.io.CompletionListener;
import org.restlet.engine.io.IoState;
import org.restlet.util.SelectionListener;
import org.restlet.util.SelectionRegistration;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Way
implements SelectionListener,
CompletionListener {
    private final ByteBuffer byteBuffer;
    private volatile BufferState byteBufferState;
    private final Connection<?> connection;
    private volatile Series<Parameter> headers;
    private volatile IoState ioState;
    private final StringBuilder lineBuilder;
    private volatile BufferState lineBuilderState;
    private volatile Response message;
    private final Queue<Response> messages;
    private volatile MessageState messageState;
    private volatile SelectionRegistration registration;

    public Way(Connection<?> connection, int bufferSize) {
        this.byteBuffer = connection.getHelper().isDirectBuffers() ? ByteBuffer.allocateDirect(bufferSize) : ByteBuffer.allocate(bufferSize);
        this.byteBufferState = BufferState.FILLING;
        this.lineBuilder = new StringBuilder();
        this.lineBuilderState = BufferState.IDLE;
        this.messages = new ConcurrentLinkedQueue<Response>();
        this.message = null;
        this.headers = null;
        this.connection = connection;
        this.messageState = MessageState.IDLE;
        this.ioState = IoState.IDLE;
        this.registration = new SelectionRegistration(0, this);
    }

    public void clear() {
        this.byteBuffer.clear();
        this.byteBufferState = BufferState.FILLING;
        this.headers = null;
        this.ioState = IoState.IDLE;
        this.clearLineBuilder();
        this.message = null;
        this.messages.clear();
        this.messageState = MessageState.IDLE;
    }

    protected void clearLineBuilder() {
        this.getLineBuilder().delete(0, this.getLineBuilder().length());
        this.setLineBuilderState(BufferState.IDLE);
    }

    protected abstract Message getActualMessage();

    protected ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    protected BufferState getByteBufferState() {
        return this.byteBufferState;
    }

    protected Connection<?> getConnection() {
        return this.connection;
    }

    protected Series<Parameter> getHeaders() {
        return this.headers;
    }

    protected ConnectionHelper<?> getHelper() {
        return this.getConnection().getHelper();
    }

    protected IoState getIoState() {
        return this.ioState;
    }

    protected StringBuilder getLineBuilder() {
        return this.lineBuilder;
    }

    protected BufferState getLineBuilderState() {
        return this.lineBuilderState;
    }

    protected Logger getLogger() {
        return this.getConnection().getLogger();
    }

    protected Response getMessage() {
        return this.message;
    }

    public Queue<Response> getMessages() {
        return this.messages;
    }

    protected MessageState getMessageState() {
        return this.messageState;
    }

    protected SelectionRegistration getRegistration() {
        return this.registration;
    }

    protected abstract int getSocketInterestOps();

    protected boolean isProcessing() {
        return this.getConnection().getState() == ConnectionState.OPEN && this.getIoState() == IoState.PROCESSING && this.getMessageState() != MessageState.IDLE;
    }

    @Override
    public void onCompleted(boolean endReached) {
        this.setIoState(IoState.IDLE);
        this.setMessageState(MessageState.IDLE);
        this.setMessage(null);
        this.setHeaders(null);
    }

    @Override
    public void onSelected(SelectionRegistration registration) {
        if (this.getIoState() == IoState.INTEREST) {
            this.setIoState(IoState.PROCESSING);
            if (this.getMessageState() == MessageState.IDLE) {
                this.setMessageState(MessageState.START);
            }
        } else if (this.getIoState() == IoState.CANCELING) {
            this.setIoState(IoState.CANCELLED);
        }
        if (!this.getByteBuffer().hasRemaining()) {
            this.getByteBuffer().clear();
            this.setByteBufferState(BufferState.FILLING);
        }
    }

    public void reuse() {
    }

    protected void setByteBufferState(BufferState byteBufferState) {
        this.byteBufferState = byteBufferState;
    }

    protected void setHeaders(Series<Parameter> headers) {
        this.headers = headers;
    }

    protected void setIoState(IoState ioState) {
        this.ioState = ioState;
    }

    protected void setLineBuilderState(BufferState lineBuilderState) {
        this.lineBuilderState = lineBuilderState;
    }

    protected void setMessage(Response message) {
        this.message = message;
    }

    protected void setMessageState(MessageState messageState) {
        if (this.messageState != messageState) {
            this.messageState = messageState;
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().fine("New message state: " + (Object)((Object)messageState));
            }
        }
    }

    protected void setRegistration(SelectionRegistration registration) {
        this.registration = registration;
    }

    public String toString() {
        return (Object)((Object)this.getIoState()) + ", " + (Object)((Object)this.getMessageState());
    }

    public void updateState() {
        this.getRegistration().setInterestOperations(this.getSocketInterestOps());
    }
}

