/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.io.StringWriter;
import java.util.Collection;
import org.restlet.data.CharacterSet;
import org.restlet.data.Reference;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.util.NamedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HeaderWriter<V>
extends StringWriter {
    @Override
    public HeaderWriter<V> append(char c) {
        super.append(c);
        return this;
    }

    public HeaderWriter<V> append(char[] cs) {
        if (cs != null) {
            for (char c : cs) {
                this.append(c);
            }
        }
        return this;
    }

    @Override
    public HeaderWriter<V> append(CharSequence csq) {
        super.append(csq);
        return this;
    }

    public HeaderWriter<V> append(Collection<V> values) {
        if (values != null && !values.isEmpty()) {
            boolean first = true;
            for (V value : values) {
                if (!this.canWrite(value)) continue;
                if (first) {
                    first = false;
                } else {
                    this.appendValueSeparator();
                }
                this.append(value);
            }
        }
        return this;
    }

    public HeaderWriter<V> append(int i) {
        return this.append(Integer.toString(i));
    }

    public HeaderWriter<V> append(long l) {
        return this.append(Long.toString(l));
    }

    public abstract HeaderWriter<V> append(V var1);

    public HeaderWriter<V> appendComment(String content) {
        this.append('(');
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (HeaderUtils.isCommentText(c)) {
                this.append(c);
                continue;
            }
            this.appendQuotedPair(c);
        }
        return this.append(')');
    }

    public HeaderWriter<V> appendExtension(NamedValue extension) {
        if (extension != null) {
            return this.appendExtension(extension.getName(), extension.getValue());
        }
        return this;
    }

    public HeaderWriter<V> appendExtension(String name, String value) {
        if (name != null && name.length() > 0) {
            this.append(name);
            if (value != null && value.length() > 0) {
                this.append("=");
                if (HeaderUtils.isToken(value)) {
                    this.append(value);
                } else {
                    this.appendQuotedString(value);
                }
            }
        }
        return this;
    }

    public HeaderWriter<V> appendParameterSeparator() {
        return this.append(";");
    }

    public HeaderWriter<V> appendProduct(String name, String version) {
        this.appendToken(name);
        if (version != null) {
            ((HeaderWriter)this.append('/')).appendToken(version);
        }
        return this;
    }

    public HeaderWriter<V> appendQuotedPair(char character) {
        return ((HeaderWriter)this.append('\\')).append(character);
    }

    public HeaderWriter<V> appendQuotedString(String content) {
        if (content != null && content.length() > 0) {
            this.append('\"');
            for (int i = 0; i < content.length(); ++i) {
                char c = content.charAt(i);
                if (HeaderUtils.isQuotedText(c)) {
                    this.append(c);
                    continue;
                }
                this.appendQuotedPair(c);
            }
            this.append('\"');
        }
        return this;
    }

    public HeaderWriter<V> appendSpace() {
        return this.append(' ');
    }

    public HeaderWriter<V> appendToken(String token) {
        if (HeaderUtils.isToken(token)) {
            return this.append(token);
        }
        throw new IllegalArgumentException("Unexpected character found in token: " + token);
    }

    public HeaderWriter<V> appendUriEncoded(CharSequence source, CharacterSet characterSet) {
        return this.append(Reference.encode(((Object)source).toString(), characterSet));
    }

    public HeaderWriter<V> appendValueSeparator() {
        return this.append(", ");
    }

    protected boolean canWrite(V value) {
        return value != null;
    }
}

