/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.routing;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.routing.Template;

public class Redirector
extends Restlet {
    public static final int MODE_CLIENT_PERMANENT = 1;
    public static final int MODE_CLIENT_FOUND = 2;
    public static final int MODE_CLIENT_SEE_OTHER = 3;
    public static final int MODE_CLIENT_TEMPORARY = 4;
    public static final int MODE_SERVER_OUTBOUND = 6;
    public static final int MODE_SERVER_INBOUND = 7;
    protected volatile String targetTemplate;
    protected volatile int mode;

    public Redirector(Context context, String targetTemplate) {
        this(context, targetTemplate, 6);
    }

    public Redirector(Context context, String targetPattern, int mode) {
        super(context);
        this.targetTemplate = targetPattern;
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    protected Reference getTargetRef(Request request, Response response) {
        Template rt = new Template(this.targetTemplate);
        rt.setLogger(this.getLogger());
        if (new Reference(this.targetTemplate).isRelative()) {
            return new Reference(request.getResourceRef(), rt.format(request, response));
        }
        return new Reference(rt.format(request, response));
    }

    public String getTargetTemplate() {
        return this.targetTemplate;
    }

    public void handle(Request request, Response response) {
        Reference targetRef = this.getTargetRef(request, response);
        switch (this.mode) {
            case 1: {
                if (request.isLoggable()) {
                    this.getLogger().log(Level.INFO, "Permanently redirecting client to: " + targetRef);
                }
                response.redirectPermanent(targetRef);
                break;
            }
            case 2: {
                if (request.isLoggable()) {
                    this.getLogger().log(Level.INFO, "Redirecting client to found location: " + targetRef);
                }
                response.setLocationRef(targetRef);
                response.setStatus(Status.REDIRECTION_FOUND);
                break;
            }
            case 3: {
                if (request.isLoggable()) {
                    this.getLogger().log(Level.INFO, "Redirecting client to another location: " + targetRef);
                }
                response.redirectSeeOther(targetRef);
                break;
            }
            case 4: {
                if (request.isLoggable()) {
                    this.getLogger().log(Level.INFO, "Temporarily redirecting client to: " + targetRef);
                }
                response.redirectTemporary(targetRef);
                break;
            }
            case 6: {
                if (request.isLoggable()) {
                    this.getLogger().log(Level.INFO, "Redirecting via client dispatcher to: " + targetRef);
                }
                this.outboundServerRedirect(targetRef, request, response);
                break;
            }
            case 7: {
                if (request.isLoggable()) {
                    this.getLogger().log(Level.INFO, "Redirecting via server dispatcher to: " + targetRef);
                }
                this.inboundServerRedirect(targetRef, request, response);
            }
        }
    }

    protected void inboundServerRedirect(Reference targetRef, Request request, Response response) {
        this.serverRedirect(this.getContext().getServerDispatcher(), targetRef, request, response);
    }

    protected void outboundServerRedirect(Reference targetRef, Request request, Response response) {
        Restlet next;
        Restlet restlet = next = this.getApplication() == null ? null : this.getApplication().getOutboundRoot();
        if (next == null) {
            next = this.getContext().getClientDispatcher();
        }
        this.serverRedirect(next, targetRef, request, response);
        if (response.getEntity() != null && !request.getResourceRef().getScheme().equalsIgnoreCase(targetRef.getScheme())) {
            response.getEntity().setLocationRef((Reference)null);
        }
    }

    protected Representation rewrite(Representation initialEntity) {
        return initialEntity;
    }

    protected void serverRedirect(Restlet next, Reference targetRef, Request request, Response response) {
        if (next == null) {
            this.getLogger().warning("No next Restlet provided for server redirection to " + targetRef);
        } else {
            Reference resourceRef = request.getResourceRef();
            Reference baseRef = resourceRef.getBaseRef();
            request.setProtocol(null);
            request.setResourceRef(targetRef);
            request.getAttributes().remove("org.restlet.http.headers");
            next.handle(request, response);
            response.setEntity(this.rewrite(response.getEntity()));
            response.getAttributes().remove("org.restlet.http.headers");
            request.setResourceRef(resourceRef);
            if (response.getLocationRef() != null) {
                String remainingPart;
                Template rt = new Template(this.targetTemplate);
                rt.setLogger(this.getLogger());
                int matched = rt.parse(response.getLocationRef().toString(), request);
                if (matched > 0 && (remainingPart = (String)request.getAttributes().get("rr")) != null) {
                    response.setLocationRef(baseRef.toString() + remainingPart);
                }
            }
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setTargetTemplate(String targetTemplate) {
        this.targetTemplate = targetTemplate;
    }
}

