/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.routing.Filter;
import org.restlet.security.Enroler;

public abstract class Authenticator
extends Filter {
    private volatile Enroler enroler;
    private volatile boolean optional;

    public Authenticator(Context context) {
        this(context, false);
    }

    public Authenticator(Context context, boolean optional) {
        this(context, optional, context != null ? context.getDefaultEnroler() : null);
    }

    public Authenticator(Context context, boolean optional, Enroler enroler) {
        super(context);
        this.optional = optional;
        this.enroler = enroler;
    }

    protected abstract boolean authenticate(Request var1, Response var2);

    protected int authenticated(Request request, Response response) {
        boolean loggable;
        boolean bl = loggable = request.isLoggable() && this.getLogger().isLoggable(Level.FINE);
        if (loggable && request.getChallengeResponse() != null) {
            this.getLogger().log(Level.FINE, "The authentication succeeded for the identifer \"" + request.getChallengeResponse().getIdentifier() + "\" using the " + request.getChallengeResponse().getScheme() + " scheme.");
        }
        if (request.getClientInfo() != null) {
            request.getClientInfo().setAuthenticated(true);
        }
        response.getChallengeRequests().clear();
        if (this.getEnroler() != null) {
            this.getEnroler().enrole(request.getClientInfo());
        }
        return 0;
    }

    protected int beforeHandle(Request request, Response response) {
        if (this.authenticate(request, response)) {
            return this.authenticated(request, response);
        }
        if (this.isOptional()) {
            response.setStatus(Status.SUCCESS_OK);
            return 0;
        }
        return this.unauthenticated(request, response);
    }

    public Enroler getEnroler() {
        return this.enroler;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setEnroler(Enroler enroler) {
        this.enroler = enroler;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    protected int unauthenticated(Request request, Response response) {
        boolean loggable;
        boolean bl = loggable = request.isLoggable() && this.getLogger().isLoggable(Level.FINE);
        if (request.getChallengeResponse() != null && loggable) {
            this.getLogger().log(Level.FINE, "The authentication failed for the identifer \"" + request.getChallengeResponse().getIdentifier() + "\" using the " + request.getChallengeResponse().getScheme() + " scheme.");
        }
        if (request.getClientInfo() != null) {
            request.getClientInfo().setAuthenticated(false);
        }
        return 2;
    }
}

