/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.util.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRepresentation
extends OutputRepresentation {
    private volatile Object dataModel;
    private volatile Template template;

    private static Template getTemplate(Representation templateRepresentation, Configuration config) {
        try {
            if (templateRepresentation.getCharacterSet() != null) {
                return new Template("template", templateRepresentation.getReader(), config, templateRepresentation.getCharacterSet().getName());
            }
            return new Template("template", templateRepresentation.getReader(), config, CharacterSet.UTF_8.getName());
        }
        catch (IOException e) {
            Context.getCurrentLogger().warning("Unable to get the template from the representation " + templateRepresentation.getIdentifier() + ". Error message: " + e.getMessage());
            return null;
        }
    }

    private static Template getTemplate(String templateName, Configuration config) {
        try {
            return config.getTemplate(templateName);
        }
        catch (IOException e) {
            Context.getCurrentLogger().warning("Unable to get the template " + templateName + ". Error message: " + e.getMessage());
            return null;
        }
    }

    public TemplateRepresentation(Representation templateRepresentation, Configuration config, MediaType mediaType) {
        this(TemplateRepresentation.getTemplate(templateRepresentation, config), mediaType);
    }

    public TemplateRepresentation(Representation templateRepresentation, Configuration config, Object dataModel, MediaType mediaType) {
        this(TemplateRepresentation.getTemplate(templateRepresentation, config), dataModel, mediaType);
    }

    public TemplateRepresentation(String templateName, Configuration config, MediaType mediaType) {
        this(TemplateRepresentation.getTemplate(templateName, config), mediaType);
    }

    public TemplateRepresentation(String templateName, Configuration config, Object dataModel, MediaType mediaType) {
        this(TemplateRepresentation.getTemplate(templateName, config), dataModel, mediaType);
    }

    public TemplateRepresentation(Template template, MediaType mediaType) {
        super(mediaType);
        this.template = template;
    }

    public TemplateRepresentation(Template template, Object dataModel, MediaType mediaType) {
        super(mediaType);
        this.template = template;
        this.dataModel = dataModel;
    }

    public Object getDataModel() {
        return this.dataModel;
    }

    public Object setDataModel(Object dataModel) {
        this.dataModel = dataModel;
        return dataModel;
    }

    public Object setDataModel(Request request, Response response) {
        this.dataModel = new ResolverHashModel((Resolver<? extends Object>)Resolver.createResolver((Request)request, (Response)response));
        return this.dataModel;
    }

    public Object setDataModel(Resolver<Object> resolver) {
        this.dataModel = new ResolverHashModel(resolver);
        return this.dataModel;
    }

    public void write(OutputStream outputStream) throws IOException {
        BufferedWriter tmplWriter = null;
        if (this.template != null) {
            try {
                tmplWriter = this.getCharacterSet() != null ? new BufferedWriter(new OutputStreamWriter(outputStream, this.getCharacterSet().getName())) : new BufferedWriter(new OutputStreamWriter(outputStream, this.template.getEncoding()));
                this.template.process(this.getDataModel(), (Writer)tmplWriter);
                ((Writer)tmplWriter).flush();
            }
            catch (TemplateException te) {
                throw new IOException("Template processing error " + te.getMessage());
            }
        } else {
            Context.getCurrentLogger().warning("Unable to write the template representation. No template found.");
        }
    }

    private class ScalarModel
    implements TemplateScalarModel {
        private final Object value;

        public ScalarModel(Object value) {
            this.value = value;
        }

        public String getAsString() throws TemplateModelException {
            return this.value.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolverHashModel
    implements TemplateHashModel {
        private final Resolver<? extends Object> resolver;

        public ResolverHashModel(Resolver<? extends Object> resolver) {
            this.resolver = resolver;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            return new ScalarModel(this.resolver.resolve(key));
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }
    }
}

