/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaas;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.ext.jaas.ChallengeCallbackHandler;
import org.restlet.security.User;
import org.restlet.security.Verifier;

public class JaasVerifier
implements Verifier {
    private volatile Configuration configuration;
    private volatile String name;
    private volatile String userPrincipalClassName;

    public JaasVerifier(String name) {
        this.name = name;
    }

    protected CallbackHandler createCallbackHandler(Request request, Response response) {
        return new ChallengeCallbackHandler(request, response);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public String getUserPrincipalClassName() {
        return this.userPrincipalClassName;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setName(String contextName) {
        this.name = contextName;
    }

    public void setUserPrincipalClassName(String userPrincipalClassName) {
        this.userPrincipalClassName = userPrincipalClassName;
    }

    public int verify(Request request, Response response) {
        int result = 4;
        try {
            Subject subject = new Subject();
            if (request.getClientInfo().getUser() != null) {
                subject.getPrincipals().add((Principal)request.getClientInfo().getUser());
            }
            if (request.getClientInfo().getRoles() != null) {
                subject.getPrincipals().addAll(request.getClientInfo().getRoles());
            }
            subject.getPrincipals().addAll(request.getClientInfo().getPrincipals());
            LoginContext loginContext = new LoginContext(this.getName(), subject, this.createCallbackHandler(request, response), this.getConfiguration());
            loginContext.login();
            for (Principal principal : subject.getPrincipals()) {
                if (!(((Object)principal).equals(request.getClientInfo().getUser()) || request.getClientInfo().getRoles().contains(principal) || request.getClientInfo().getPrincipals().contains(principal))) {
                    request.getClientInfo().getPrincipals().add(principal);
                }
                if (request.getClientInfo().getUser() != null || this.userPrincipalClassName == null || !principal.getClass().getName().equals(this.userPrincipalClassName)) continue;
                request.getClientInfo().setUser(new User(principal.getName()));
            }
        }
        catch (LoginException le) {
            result = -1;
        }
        return result;
    }
}

