/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.restlet.data.CookieSetting;
import org.restlet.data.Form;
import org.restlet.data.Reference;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.AuthorizationBaseServerResource;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.HttpOAuthHelper;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.AuthSession;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.routing.Redirector;
import org.restlet.security.Role;
import org.restlet.security.User;

public class AuthorizationServerResource
extends AuthorizationBaseServerResource {
    @Get(value="html")
    @Post(value="html")
    public Representation represent() throws OAuthException {
        AuthSession session;
        String redirectURI;
        Client client;
        Form params = this.getQuery();
        try {
            client = this.getClient(params);
            redirectURI = this.getRedirectURI(params, client);
        }
        catch (OAuthException ex) {
            return this.getErrorPage(HttpOAuthHelper.getErrorPageTemplate(this.getContext()), ex);
        }
        catch (Exception ex) {
            OAuthException oex = new OAuthException(OAuthError.server_error, ex.getMessage(), null);
            return this.getErrorPage(HttpOAuthHelper.getErrorPageTemplate(this.getContext()), oex);
        }
        try {
            ResponseType responseType = this.getResponseType(params);
            session = this.getAuthSession(client, responseType, redirectURI);
            String[] scope = this.getScope(params);
            session.setRequestedScope(scope);
        }
        catch (OAuthException ex) {
            this.ungetAuthSession();
            throw ex;
        }
        if (session.getScopeOwner() == null) {
            Reference ref = new Reference("." + HttpOAuthHelper.getLoginPage(this.getContext()));
            ref.addQueryParameter("continue", this.getRequest().getOriginalRef().toString(true, false));
            this.redirectTemporary(ref.toString());
            return new EmptyRepresentation();
        }
        return this.doPostAuthorization(session);
    }

    protected Representation doPostAuthorization(AuthSession session) {
        List<Role> roles;
        AuthenticatedUser user;
        Reference ref = new Reference("riap://application" + HttpOAuthHelper.getAuthPage(this.getContext()));
        this.getLogger().fine("Name = " + this.getApplication().getInboundRoot());
        ref.addQueryParameter("client", session.getClient().getClientId());
        String[] scopes = session.getRequestedScope();
        if (scopes != null && scopes.length > 0) {
            for (String s : scopes) {
                ref.addQueryParameter("scope", s);
            }
        }
        if ((user = session.getClient().findUser(session.getScopeOwner())) != null && (roles = user.getGrantedRoles()) != null && roles.size() > 0) {
            for (Role r : roles) {
                ref.addQueryParameter("grantedScope", Scopes.toScope(r));
            }
        }
        this.getLogger().fine("Redir = " + ref);
        Redirector dispatcher = new Redirector(this.getContext(), ref.toString(), 6);
        this.getRequest().getAttributes().put("_cid", session.getId());
        dispatcher.handle(this.getRequest(), this.getResponse());
        return this.getResponseEntity();
    }

    protected ResponseType getResponseType(Form params) throws OAuthException {
        String typeString = params.getFirstValue("response_type");
        try {
            ResponseType type = Enum.valueOf(ResponseType.class, typeString);
            this.getLogger().fine("Found flow - " + (Object)((Object)type));
            return type;
        }
        catch (IllegalArgumentException iae) {
            throw new OAuthException(OAuthError.unsupported_response_type, "Unsupported flow", null);
        }
        catch (NullPointerException npe) {
            throw new OAuthException(OAuthError.invalid_request, "No response_type parameter found.", null);
        }
    }

    protected String getRedirectURI(Form params, Client client) throws OAuthException {
        String redirUri = params.getFirstValue("redirect_uri");
        if (redirUri == null || redirUri.isEmpty()) {
            redirUri = client.getRedirectUri();
            if (redirUri == null) {
                throw new OAuthException(OAuthError.invalid_request, "Client MUST include a redirection URI.", null);
            }
        } else if (!redirUri.startsWith(client.getRedirectUri())) {
            throw new OAuthException(OAuthError.invalid_request, "Callback URI does not match.", null);
        }
        return redirUri;
    }

    private AuthSession getAuthSession(Client client, ResponseType responseType, String redirectURI) {
        AuthSession session = this.getAuthSession();
        session = this.setupSession(session, client, responseType, redirectURI);
        User scopeOwner = this.getRequest().getClientInfo().getUser();
        if (scopeOwner != null) {
            session.setScopeOwner(scopeOwner.getIdentifier());
        }
        return session;
    }

    private void ungetAuthSession() {
        String sessionId = this.getCookies().getFirstValue("_cid");
        if (sessionId != null && sessionId.length() > 0) {
            ConcurrentMap attribs = this.getContext().getAttributes();
            attribs.remove(sessionId);
        }
    }

    protected AuthSession setupSession(AuthSession in, Client client, ResponseType flow, String redirUri) {
        String state;
        this.getLogger().fine("Base ref = " + this.getReference().getParentRef());
        this.getLogger().fine("OAuth2 session = " + in);
        AuthSession session = in;
        if (session == null) {
            session = new AuthSession(this.getContext().getAttributes(), new ScheduledThreadPoolExecutor(5));
            CookieSetting cs = new CookieSetting("_cid", session.getId());
            this.getCookieSettings().add((Object)cs);
            this.getLogger().fine("Setting cookie in SetupSession - " + session.getId());
        }
        session.setClient(client);
        session.setAuthFlow(flow);
        if (!redirUri.equals(client.getRedirectUri())) {
            session.setDynamicCallbackURI(redirUri);
            this.getLogger().fine("OAuth2 set dynamic callback = " + redirUri);
        }
        if ((state = this.getCookies().getFirstValue("state")) != null && !state.isEmpty()) {
            session.setState(state);
        }
        return session;
    }
}

