/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONException;
import org.restlet.Context;
import org.restlet.Response;
import org.restlet.data.CacheDirective;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.ClientStore;
import org.restlet.ext.oauth.ClientStoreFactory;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.ext.oauth.internal.TokenGenerator;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public abstract class OAuthServerResource
extends ServerResource {
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String RESPONSE_TYPE = "response_type";
    public static final String SCOPE = "scope";
    public static final String STATE = "state";
    public static final String REDIR_URI = "redirect_uri";
    public static final String ERROR = "error";
    public static final String ERROR_DESC = "error_description";
    public static final String ERROR_URI = "error_uri";
    public static final String GRANT_TYPE = "grant_type";
    public static final String CODE = "code";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String TOKEN_TYPE = "token_type";
    public static final String EXPIRES_IN = "expires_in";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String TOKEN_TYPE_BEARER = "Bearer";
    public static final String TOKEN_TYPE_MAC = "mac";
    public static final String AUTONOMOUS_USER = "__autonomous";
    public static final String ClientCookieID = "_cid";
    public static final String TOKEN_SERVER_MAX_TIME_SEC = "_token_server_max_time_sec";
    public static final String TOKEN_SERVER_TIME_SEC = "_token_server_time_sec";
    protected volatile ClientStore<?> clients;
    protected volatile TokenGenerator generator;
    protected volatile long tokenMaxTimeSec = 0L;
    protected volatile long tokenTimeSec = 0L;

    protected void doInit() throws ResourceException {
        super.doInit();
        Context ctx = this.getContext();
        ConcurrentMap attribs = ctx.getAttributes();
        this.clients = ClientStoreFactory.getInstance();
        this.getLogger().fine("Found client store = " + this.clients);
        this.generator = this.clients.getTokenGenerator();
        this.getLogger().fine("Found token generator = " + this.generator);
        if (attribs.containsKey(TOKEN_SERVER_TIME_SEC)) {
            this.tokenTimeSec = (Long)attribs.get(TOKEN_SERVER_TIME_SEC);
        }
        if (attribs.containsKey(TOKEN_SERVER_MAX_TIME_SEC)) {
            this.tokenMaxTimeSec = (Long)attribs.get(TOKEN_SERVER_MAX_TIME_SEC);
        }
        this.generator.setMaxTokenTime(this.tokenMaxTimeSec);
    }

    protected String getParameter(String parameter, String defaultValue) {
        String val = (String)this.getContext().getAttributes().get(parameter);
        return val != null ? val : defaultValue;
    }

    protected Client getClient(Form params) throws OAuthException {
        String clientId = params.getFirstValue(CLIENT_ID);
        if (clientId == null || clientId.isEmpty()) {
            this.getLogger().warning("Could not find client ID");
            throw new OAuthException(OAuthError.invalid_request, "No client_id parameter found.", null);
        }
        Client client = this.clients.findById(clientId);
        this.getLogger().fine("Client = " + client);
        if (client == null) {
            this.getLogger().warning("Need to register the client : " + clientId);
            throw new OAuthException(OAuthError.invalid_request, "Need to register the client : " + clientId, null);
        }
        return client;
    }

    protected String[] getScope(Form params) throws OAuthException {
        String scope = params.getFirstValue(SCOPE);
        if (scope == null || scope.isEmpty()) {
            String defaultScope = this.getParameter("defaultScope", null);
            if (defaultScope == null || defaultScope.toString().isEmpty()) {
                throw new OAuthException(OAuthError.invalid_scope, "Scope has not provided.", null);
            }
            scope = defaultScope.toString();
        }
        return Scopes.parseScope(scope);
    }

    protected String getState(Form params) {
        return params.getFirstValue(STATE);
    }

    public static Representation responseErrorRepresentation(OAuthException ex) {
        try {
            return new JsonRepresentation(ex.createErrorDocument());
        }
        catch (JSONException e) {
            StringRepresentation r = new StringRepresentation((CharSequence)("{\"error\":\"server_error\",\"error_description:\":\"" + e.getLocalizedMessage() + "\"}"));
            r.setMediaType(MediaType.APPLICATION_JSON);
            return r;
        }
    }

    public static void addCacheDirective(Response response, CacheDirective cacheDirective) {
        ArrayList<CacheDirective> cacheDirectives = response.getCacheDirectives();
        if (cacheDirectives == null) {
            cacheDirectives = new ArrayList<CacheDirective>();
            response.setCacheDirectives(cacheDirectives);
        }
        cacheDirectives.add(cacheDirective);
    }
}

