/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata.internal.edm;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.restlet.ext.odata.internal.edm.ComplexProperty;
import org.restlet.ext.odata.internal.edm.NamedObject;
import org.restlet.ext.odata.internal.edm.Property;
import org.restlet.ext.odata.internal.edm.Schema;
import org.restlet.ext.odata.internal.edm.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODataType
extends NamedObject
implements Comparable<ODataType> {
    private boolean abstractType;
    private ODataType baseType;
    private List<ComplexProperty> complexProperties;
    private List<Property> properties;
    private Schema schema;

    public ODataType(String name) {
        super(name);
    }

    @Override
    public int compareTo(ODataType o) {
        if (o == null) {
            return 1;
        }
        int result = 0;
        String s1 = this.getFullClassName();
        String s2 = o.getFullClassName();
        if (s1 != null) {
            result = s1.compareTo(s2);
        } else if (s2 != null) {
            result = -1 * s2.compareTo(s1);
        }
        return result;
    }

    public ODataType getBaseType() {
        return this.baseType;
    }

    public String getClassName() {
        return this.getNormalizedName().substring(0, 1).toUpperCase() + this.getNormalizedName().substring(1);
    }

    public List<ComplexProperty> getComplexProperties() {
        if (this.complexProperties == null) {
            this.complexProperties = new ArrayList<ComplexProperty>();
        }
        return this.complexProperties;
    }

    public String getFullClassName() {
        return this.getPackageName() + "." + this.getClassName();
    }

    public Set<String> getImportedJavaClasses() {
        TreeSet<String> result = new TreeSet<String>();
        for (Property property : this.getProperties()) {
            if (property.getType() == null) continue;
            result.addAll(property.getType().getImportedJavaClasses());
        }
        for (ComplexProperty complexProperty : this.getComplexProperties()) {
            if (complexProperty.getComplexType() == null || complexProperty.getComplexType().getSchema().equals(this.getSchema())) continue;
            result.add(complexProperty.getComplexType().getFullClassName());
        }
        return result;
    }

    public Set<ODataType> getImportedTypes() {
        return new TreeSet<ODataType>();
    }

    public String getPackageName() {
        return TypeUtils.getPackageName(this.getSchema());
    }

    public List<Property> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        return this.properties;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public boolean isAbstractType() {
        return this.abstractType;
    }

    public void setAbstractType(boolean abstractType) {
        this.abstractType = abstractType;
    }

    public void setBaseType(ODataType baseType) {
        this.baseType = baseType;
    }

    public void setComplexProperties(List<ComplexProperty> complexProperties) {
        this.complexProperties = complexProperties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }
}

