/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf.internal.turtle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Reference;
import org.restlet.ext.rdf.Link;
import org.restlet.ext.rdf.internal.turtle.Context;
import org.restlet.ext.rdf.internal.turtle.LexicalUnit;
import org.restlet.ext.rdf.internal.turtle.RdfTurtleReader;

public class BlankNodeToken
extends LexicalUnit {
    private List<LexicalUnit> lexicalUnits;
    private boolean resolved = false;

    public List<LexicalUnit> getLexicalUnits() {
        return this.lexicalUnits;
    }

    public BlankNodeToken(RdfTurtleReader contentHandler, Context context) throws IOException {
        super(contentHandler, context);
        this.lexicalUnits = new ArrayList<LexicalUnit>();
        this.setValue("_:" + contentHandler.newBlankNodeId());
        this.lexicalUnits.add(this);
        this.parse();
    }

    public BlankNodeToken(String value) {
        super(value);
        this.resolved = true;
    }

    @Override
    public void parse() throws IOException {
        this.getContentReader().parseBlankNode(this);
    }

    @Override
    public Object resolve() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.getContentReader() != null) {
                this.getContentReader().generateLinks(this.lexicalUnits);
            }
        }
        if (this.getValue() != null) {
            if (this.getValue().startsWith("_:")) {
                return new Reference(this.getValue());
            }
            return Link.createBlankRef(this.getValue());
        }
        org.restlet.Context.getCurrentLogger().warning("A blank node has been detected with a null value.");
        return null;
    }
}

