/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf.internal.turtle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.data.Reference;

public class Context {
    private Reference base;
    private List<String> keywords;
    private Map<String, String> prefixes = new HashMap<String, String>();

    public Context() {
        this.prefixes.put(":", "#");
        this.keywords = new ArrayList<String>();
    }

    public Reference getBase() {
        if (this.base == null) {
            this.base = new Reference();
        }
        return this.base;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public Map<String, String> getPrefixes() {
        return this.prefixes;
    }

    public boolean isQName(String value) {
        boolean result = value.indexOf(":") != -1 || this.getKeywords().contains(value);
        return result;
    }

    public Reference resolve(String qname) {
        Reference result = null;
        int index = qname.indexOf(":");
        if (index != -1) {
            String prefix = qname.substring(0, index + 1);
            String base = this.getPrefixes().get(prefix);
            if (base != null) {
                result = new Reference(base + qname.substring(index + 1));
            } else {
                org.restlet.Context.getCurrentLogger().warning("Error, this prefix " + prefix + " has not been declared!");
            }
        } else if (this.getKeywords().contains(qname)) {
            String base = this.getPrefixes().get(":");
            if (base != null) {
                result = new Reference(base + qname);
            } else {
                org.restlet.Context.getCurrentLogger().warning("Error, the empty prefix has not been declared!");
            }
        } else {
            result = new Reference(this.getBase().toString() + qname);
        }
        return result;
    }

    public void setBase(Reference base) {
        this.base = base;
    }
}

