/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rome;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.WriterRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyndFeedRepresentation
extends WriterRepresentation {
    private final SyndFeed feed;

    public SyndFeedRepresentation() {
        this("rss_2.0");
    }

    public SyndFeedRepresentation(String feedType) {
        this(feedType, CharacterSet.UTF_8);
    }

    public SyndFeedRepresentation(String feedType, CharacterSet characterSet) {
        this(feedType, new ArrayList(), characterSet);
    }

    public SyndFeedRepresentation(String feedType, List<?> entries, CharacterSet characterSet) {
        super(feedType.startsWith("atom") ? MediaType.APPLICATION_ATOM : MediaType.APPLICATION_RSS);
        this.setCharacterSet(characterSet);
        this.feed = new SyndFeedImpl();
        this.feed.setFeedType(feedType);
        this.feed.setEntries(entries);
    }

    public SyndFeedRepresentation(SyndFeed feed) {
        super(feed.getFeedType().startsWith("atom") ? MediaType.APPLICATION_ATOM : MediaType.APPLICATION_RSS);
        this.feed = feed;
    }

    public SyndFeed getFeed() {
        return this.feed;
    }

    public void write(Writer writer) throws IOException {
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            output.output(this.feed, writer);
        }
        catch (FeedException e) {
            IOException ioe = new IOException("Feed exception");
            ioe.initCause(e);
            throw ioe;
        }
    }
}

