/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.servlet;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Reference;
import org.restlet.engine.http.HttpRequest;
import org.restlet.engine.http.HttpResponse;
import org.restlet.engine.http.ServerCall;
import org.restlet.engine.http.adapter.ServerAdapter;
import org.restlet.ext.servlet.internal.ServletCall;

public class ServletAdapter
extends ServerAdapter {
    private volatile Restlet next;

    public ServletAdapter(ServletContext context) {
        this(context, null);
    }

    public ServletAdapter(ServletContext context, Restlet next) {
        super(new Context());
        this.next = next;
    }

    public Reference getBaseRef(HttpServletRequest request) {
        int baseIndex;
        Reference result = null;
        String basePath = request.getContextPath() + request.getServletPath();
        String baseUri = request.getRequestURL().toString();
        int pathStart = baseUri.indexOf("/", request.getScheme().length() + 3);
        if (basePath.length() == 0) {
            result = pathStart != -1 ? new Reference(baseUri.substring(0, pathStart)) : new Reference(baseUri);
        } else if (pathStart != -1 && (baseIndex = baseUri.indexOf(basePath, pathStart)) != -1) {
            result = new Reference(baseUri.substring(0, baseIndex + basePath.length()));
        }
        return result;
    }

    public Restlet getNext() {
        return this.next;
    }

    public Reference getRootRef(HttpServletRequest request) {
        return this.getBaseRef(request);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) {
        if (this.getNext() != null) {
            Context.setCurrent((Context)this.getContext());
            ServletCall servletCall = new ServletCall(request.getLocalAddr(), request.getLocalPort(), request, response);
            HttpRequest httpRequest = this.toRequest(servletCall);
            HttpResponse httpResponse = new HttpResponse((ServerCall)servletCall, (Request)httpRequest);
            httpRequest.getResourceRef().setBaseRef(this.getBaseRef(request));
            httpRequest.setRootRef(this.getRootRef(request));
            this.getNext().handle((Request)httpRequest, (Response)httpResponse);
            this.commit(httpResponse);
        } else {
            this.getLogger().warning("Unable to find the Restlet target");
        }
    }

    public void setNext(Restlet next) {
        this.next = next;
    }

    public HttpRequest toRequest(ServletCall servletCall) {
        HttpRequest result = super.toRequest((ServerCall)servletCall);
        Enumeration namesEnum = servletCall.getRequest().getAttributeNames();
        while (namesEnum.hasMoreElements()) {
            String attributeName = (String)namesEnum.nextElement();
            result.getAttributes().put(attributeName, servletCall.getRequest().getAttribute(attributeName));
        }
        return result;
    }
}

