/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.header.Header;
import org.restlet.ext.wadl.ApplicationInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.ext.wadl.RequestInfo;
import org.restlet.ext.wadl.ResourceInfo;
import org.restlet.ext.wadl.ResponseInfo;
import org.restlet.ext.wadl.WadlRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.restlet.util.NamedValue;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlServerResource
extends ServerResource {
    private volatile boolean autoDescribing = true;
    private volatile String description;
    private volatile String name;

    public boolean canDescribe(Method method) {
        return !Method.HEAD.equals((Object)method) && !Method.OPTIONS.equals((Object)method);
    }

    protected Representation createHtmlRepresentation(ApplicationInfo applicationInfo) {
        return new WadlRepresentation(applicationInfo).getHtmlRepresentation();
    }

    protected Representation createWadlRepresentation(ApplicationInfo applicationInfo) {
        return new WadlRepresentation(applicationInfo);
    }

    protected Representation describe() {
        return this.describe(this.getPreferredWadlVariant());
    }

    protected void describe(ApplicationInfo applicationInfo) {
    }

    protected RepresentationInfo describe(MethodInfo methodInfo, Class<?> representationClass, Variant variant) {
        return new RepresentationInfo(variant);
    }

    protected RepresentationInfo describe(MethodInfo methodInfo, RequestInfo requestInfo, Class<?> representationClass, Variant variant) {
        return this.describe(methodInfo, representationClass, variant);
    }

    protected RepresentationInfo describe(MethodInfo methodInfo, ResponseInfo responseInfo, Class<?> representationClass, Variant variant) {
        return this.describe(methodInfo, representationClass, variant);
    }

    public void describe(ResourceInfo info) {
        this.describe(this.getResourcePath(), info);
    }

    public void describe(String path, ResourceInfo info) {
        ResourceInfo.describe(null, info, (Object)this, path);
    }

    protected Representation describe(Variant variant) {
        Representation result = null;
        if (variant != null) {
            ResourceInfo resource = new ResourceInfo();
            this.describe(resource);
            ApplicationInfo application = resource.createApplication();
            this.describe(application);
            if (MediaType.APPLICATION_WADL.equals((Object)variant.getMediaType())) {
                result = this.createWadlRepresentation(application);
            } else if (MediaType.TEXT_HTML.equals((Object)variant.getMediaType())) {
                result = this.createHtmlRepresentation(application);
            }
        }
        return result;
    }

    protected void describeDelete(MethodInfo info) {
        MethodInfo.describeAnnotations(info, this);
    }

    protected void describeGet(MethodInfo info) {
        MethodInfo.describeAnnotations(info, this);
    }

    protected MethodInfo describeMethod() {
        MethodInfo result = new MethodInfo();
        this.describeMethod(this.getMethod(), result);
        return result;
    }

    protected void describeMethod(Method method, MethodInfo info) {
        info.setName(method);
        if (Method.GET.equals((Object)method)) {
            this.describeGet(info);
        } else if (Method.POST.equals((Object)method)) {
            this.describePost(info);
        } else if (Method.PUT.equals((Object)method)) {
            this.describePut(info);
        } else if (Method.DELETE.equals((Object)method)) {
            this.describeDelete(info);
        } else if (Method.OPTIONS.equals((Object)method)) {
            this.describeOptions(info);
        }
    }

    protected void describeOptions(MethodInfo info) {
        for (Variant variant : this.getWadlVariants()) {
            RepresentationInfo result = new RepresentationInfo(variant);
            info.getResponse().getRepresentations().add(result);
        }
    }

    protected List<ParameterInfo> describeParameters() {
        return null;
    }

    protected void describePost(MethodInfo info) {
        MethodInfo.describeAnnotations(info, this);
    }

    protected void describePut(MethodInfo info) {
        MethodInfo.describeAnnotations(info, this);
    }

    protected void doInit() throws ResourceException {
        super.doInit();
        this.autoDescribing = true;
    }

    public String getDescription() {
        return this.description;
    }

    private Series<Header> getHeaders() {
        return (Series)this.getRequestAttributes().get("org.restlet.http.headers");
    }

    public String getName() {
        return this.name;
    }

    protected NamedValue<String> getParameter(String name) {
        NamedValue result = null;
        Series<? extends NamedValue<String>> set = this.getParameters(name);
        if (set != null) {
            result = set.getFirst(name);
        }
        return result;
    }

    private Series<? extends NamedValue<String>> getParameters(ParameterInfo parameterInfo) {
        Series result = null;
        if (parameterInfo.getFixed() != null) {
            result = new Series(Parameter.class);
            result.add(parameterInfo.getName(), parameterInfo.getFixed());
        } else if (ParameterStyle.HEADER.equals((Object)parameterInfo.getStyle())) {
            result = this.getHeaders().subList(parameterInfo.getName());
        } else if (ParameterStyle.TEMPLATE.equals((Object)parameterInfo.getStyle())) {
            Object parameter = this.getRequest().getAttributes().get(parameterInfo.getName());
            if (parameter != null) {
                result = new Series(Parameter.class);
                result.add(parameterInfo.getName(), Reference.decode((String)((String)parameter)));
            }
        } else if (ParameterStyle.MATRIX.equals((Object)parameterInfo.getStyle())) {
            result = this.getMatrix().subList(parameterInfo.getName());
        } else if (ParameterStyle.QUERY.equals((Object)parameterInfo.getStyle())) {
            result = this.getQuery().subList(parameterInfo.getName());
        } else if (ParameterStyle.PLAIN.equals((Object)parameterInfo.getStyle())) {
            // empty if block
        }
        if (result == null && parameterInfo.getDefaultValue() != null) {
            result = new Series(Parameter.class);
            result.add(parameterInfo.getName(), parameterInfo.getDefaultValue());
        }
        return result;
    }

    protected Series<? extends NamedValue<String>> getParameters(String name) {
        Series<? extends NamedValue<String>> result = null;
        if (this.describeParameters() != null) {
            for (ParameterInfo parameter : this.describeParameters()) {
                if (!name.equals(parameter.getName())) continue;
                result = this.getParameters(parameter);
            }
        }
        return result;
    }

    protected Variant getPreferredWadlVariant() {
        return this.getConnegService().getPreferredVariant(this.getWadlVariants(), this.getRequest(), this.getMetadataService());
    }

    protected String getResourcePath() {
        Reference ref = new Reference(this.getRequest().getRootRef(), this.getRequest().getResourceRef());
        return ref.getRemainingPart();
    }

    protected Reference getResourcesBase() {
        return this.getRequest().getRootRef();
    }

    protected List<Variant> getWadlVariants() {
        ArrayList<Variant> result = new ArrayList<Variant>();
        result.add(new Variant(MediaType.APPLICATION_WADL));
        result.add(new Variant(MediaType.TEXT_HTML));
        return result;
    }

    public boolean isAutoDescribing() {
        return this.autoDescribing;
    }

    public Representation options() {
        if (this.isAutoDescribing()) {
            return this.describe();
        }
        return null;
    }

    public void setAutoDescribing(boolean autoDescribed) {
        this.autoDescribing = autoDescribed;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }
}

