/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.restlet.Context;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.ext.xml.XmlRepresentation;
import org.restlet.ext.xml.internal.AbstractXmlReader;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformRepresentation
extends OutputRepresentation {
    private volatile Map<String, String> outputProperties;
    private volatile Map<String, Object> parameters;
    private volatile Representation sourceRepresentation;
    private volatile Templates templates;
    private volatile Representation transformSheet;
    private volatile URIResolver uriResolver;

    public TransformRepresentation(Context context, Representation source, Representation transformSheet) {
        this((URIResolver)(context == null ? null : new ContextResolver(context)), source, transformSheet);
    }

    public TransformRepresentation(Representation source, Representation transformSheet) {
        this((URIResolver)null, source, transformSheet);
    }

    public TransformRepresentation(URIResolver uriResolver, Representation source, Representation transformSheet) {
        this(uriResolver, source, transformSheet, null);
    }

    private TransformRepresentation(URIResolver uriResolver, Representation source, Representation transformSheet, Templates templates) {
        super(null);
        this.sourceRepresentation = source;
        this.templates = templates;
        this.transformSheet = transformSheet;
        this.uriResolver = uriResolver;
        this.parameters = new HashMap<String, Object>();
        this.outputProperties = new HashMap<String, String>();
    }

    public TransformRepresentation(URIResolver uriResolver, Representation source, Templates templates) {
        this(uriResolver, source, null, templates);
    }

    public Map<String, String> getOutputProperties() {
        return this.outputProperties;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public SAXSource getSaxSource() throws IOException {
        SAXSource result = null;
        if (this.getSourceRepresentation() instanceof XmlRepresentation) {
            result = ((XmlRepresentation)this.getSourceRepresentation()).getSaxSource();
        } else if (this.getSourceRepresentation() instanceof TransformRepresentation) {
            AbstractXmlReader reader = new AbstractXmlReader(){

                public void parse(String systemId) throws IOException, SAXException {
                    throw new IllegalStateException("Not implemented");
                }

                public void parse(InputSource input) throws IOException, SAXException {
                    try {
                        TransformRepresentation source = (TransformRepresentation)TransformRepresentation.this.getSourceRepresentation();
                        source.getTransformer().transform(source.getSaxSource(), new SAXResult(this.getContentHandler()));
                    }
                    catch (TransformerException te) {
                        throw new IOException("Transformer exception. " + te.getMessage());
                    }
                }
            };
            result = new SAXSource(reader, null);
        } else {
            result = new SAXSource(new InputSource(this.getSourceRepresentation().getReader()));
        }
        if (this.getSourceRepresentation().getIdentifier() != null) {
            result.setSystemId(this.getSourceRepresentation().getIdentifier().getTargetRef().toString());
        }
        return result;
    }

    private SAXTransformerFactory getSaxTransformerFactory() {
        SAXTransformerFactory result = (SAXTransformerFactory)TransformerFactory.newInstance();
        return result;
    }

    public Representation getSourceRepresentation() {
        return this.sourceRepresentation;
    }

    public Templates getTemplates() throws IOException {
        if (this.templates == null && this.getTransformSheet() != null) {
            try {
                StreamSource transformSource = new StreamSource(this.getTransformSheet().getStream());
                if (this.getTransformSheet().getIdentifier() != null) {
                    transformSource.setSystemId(this.getTransformSheet().getIdentifier().getTargetRef().toString());
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                if (this.getUriResolver() != null) {
                    transformerFactory.setURIResolver(this.getUriResolver());
                }
                this.templates = transformerFactory.newTemplates(transformSource);
            }
            catch (TransformerConfigurationException tce) {
                throw new IOException("Transformer configuration exception. " + tce.getMessage());
            }
        }
        return this.templates;
    }

    public Transformer getTransformer() throws IOException {
        Transformer result = null;
        try {
            Templates templates = this.getTemplates();
            if (templates != null) {
                result = templates.newTransformer();
                if (this.uriResolver != null) {
                    result.setURIResolver(this.getUriResolver());
                }
                for (String name : this.getParameters().keySet()) {
                    result.setParameter(name, this.getParameters().get(name));
                }
                for (String name : this.getOutputProperties().keySet()) {
                    result.setOutputProperty(name, this.getOutputProperties().get(name));
                }
            }
        }
        catch (TransformerConfigurationException tce) {
            throw new IOException("Transformer configuration exception. " + tce.getMessage());
        }
        catch (TransformerFactoryConfigurationError tfce) {
            throw new IOException("Transformer factory configuration exception. " + tfce.getMessage());
        }
        return result;
    }

    public TransformerHandler getTransformerHandler() throws IOException {
        TransformerHandler result = null;
        Templates templates = this.getTemplates();
        if (templates != null) {
            try {
                result = this.getSaxTransformerFactory().newTransformerHandler(templates);
            }
            catch (TransformerConfigurationException tce) {
                throw new IOException("Transformer configuration exception. " + tce.getMessage());
            }
        }
        return result;
    }

    public Representation getTransformSheet() {
        return this.transformSheet;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public XMLFilter getXmlFilter() throws IOException {
        XMLFilter result = null;
        Templates templates = this.getTemplates();
        if (templates != null) {
            try {
                result = this.getSaxTransformerFactory().newXMLFilter(templates);
            }
            catch (TransformerConfigurationException tce) {
                throw new IOException("Transformer configuration exception. " + tce.getMessage());
            }
        }
        return result;
    }

    public void release() {
        if (this.sourceRepresentation != null) {
            this.sourceRepresentation.release();
            this.sourceRepresentation = null;
        }
        if (this.templates != null) {
            this.templates = null;
        }
        if (this.transformSheet != null) {
            this.transformSheet.release();
            this.transformSheet = null;
        }
        if (this.uriResolver != null) {
            this.uriResolver = null;
        }
        super.release();
    }

    public void setOutputProperties(Map<String, String> outputProperties) {
        this.outputProperties = outputProperties;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setSourceRepresentation(Representation source) {
        this.sourceRepresentation = source;
    }

    public void setTemplates(Templates templates) {
        this.templates = templates;
    }

    public void setTransformSheet(Representation transformSheet) {
        this.transformSheet = transformSheet;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.getTransformer() == null) {
            Context.getCurrentLogger().warning("Unable to apply the transformation. No transformer found!");
        } else {
            try {
                this.getTransformer().transform(this.getSaxSource(), new StreamResult(outputStream));
            }
            catch (TransformerException te) {
                throw new IOException("Transformer exception. " + te.getMessage());
            }
        }
    }

    private static final class ContextResolver
    implements URIResolver {
        private final Context context;

        public ContextResolver(Context context) {
            this.context = context;
        }

        public Source resolve(String href, String base) throws TransformerException {
            StreamSource result = null;
            if (this.context != null) {
                Reference targetRef = null;
                if (base != null && !base.equals("")) {
                    Reference baseRef = new Reference(base);
                    targetRef = new Reference(baseRef, href);
                } else {
                    targetRef = new Reference(href);
                }
                String targetUri = targetRef.getTargetRef().toString();
                Response response = this.context.getClientDispatcher().get(targetUri);
                if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
                    try {
                        result = new StreamSource(response.getEntity().getStream());
                        result.setSystemId(targetUri);
                    }
                    catch (IOException e) {
                        this.context.getLogger().log(Level.WARNING, "I/O error while getting the response stream", e);
                    }
                }
            }
            return result;
        }
    }
}

