/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Enumeration;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public final class XmlWriter
extends XMLFilterImpl {
    private static final Object SEEN_NOTHING = new Object();
    private static final Object SEEN_ELEMENT = new Object();
    private static final Object SEEN_DATA = new Object();
    private final Attributes EMPTY_ATTS = new AttributesImpl();
    private volatile Map<String, String> prefixTable;
    private volatile Map<String, Boolean> forcedDeclTable;
    private volatile Map<String, String> doneDeclTable;
    private volatile int elementLevel = 0;
    private volatile NamespaceSupport nsSupport;
    private volatile int prefixCounter = 0;
    private volatile Writer output;
    private volatile Object state = SEEN_NOTHING;
    private volatile Stack<Object> stateStack = new Stack();
    private volatile boolean dataFormat = false;
    private volatile int indentStep = 0;
    private volatile int depth = 0;

    public XmlWriter() {
        this.init(null);
    }

    public XmlWriter(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public XmlWriter(OutputStream out, Charset cs) {
        this(new OutputStreamWriter(out, cs));
    }

    public XmlWriter(OutputStream out, CharsetEncoder enc) {
        this(new OutputStreamWriter(out, enc));
    }

    public XmlWriter(OutputStream out, String charsetName) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(out, charsetName));
    }

    public XmlWriter(Writer writer) {
        this.init(writer);
    }

    public XmlWriter(XMLReader xmlreader) {
        super(xmlreader);
        this.init(null);
    }

    public XmlWriter(XMLReader xmlreader, Writer writer) {
        super(xmlreader);
        this.init(writer);
    }

    private void characters(boolean dataFormat, char[] ch, int start, int len) throws SAXException {
        if (dataFormat) {
            this.state = SEEN_DATA;
        }
        this.writeEsc(ch, start, len, false);
        super.characters(ch, start, len);
    }

    private void characters(boolean dataFormat, String data) throws SAXException {
        char[] ch = data.toCharArray();
        this.characters(dataFormat, ch, 0, ch.length);
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this.characters(this.isDataFormat(), ch, start, len);
    }

    public void characters(String data) throws SAXException {
        this.characters(false, data);
    }

    public void dataElement(String localName, String content) throws SAXException {
        this.dataElement("", localName, "", this.EMPTY_ATTS, content);
    }

    public void dataElement(String uri, String localName, String content) throws SAXException {
        this.dataElement(uri, localName, "", this.EMPTY_ATTS, content);
    }

    public void dataElement(String uri, String localName, String qName, Attributes atts, String content) throws SAXException {
        this.startElement(uri, localName, qName, atts);
        this.characters(content);
        this.endElement(uri, localName, qName);
    }

    private void doIndent() throws SAXException {
        if (this.indentStep > 0 && this.depth > 0) {
            int n = this.indentStep * this.depth;
            char[] ch = new char[n];
            for (int i = 0; i < n; ++i) {
                ch[i] = 32;
            }
            this.characters(ch, 0, n);
        }
    }

    private String doPrefix(String uri, String qName, boolean isElement) {
        String defaultNS = this.nsSupport.getURI("");
        if ("".equals(uri) || uri == null) {
            if (isElement && defaultNS != null) {
                this.nsSupport.declarePrefix("", "");
            }
            return null;
        }
        String prefix = isElement && defaultNS != null && uri.equals(defaultNS) ? "" : this.nsSupport.getPrefix(uri);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.doneDeclTable.get(uri);
        if (prefix != null && ((!isElement || defaultNS != null) && "".equals(prefix) || this.nsSupport.getURI(prefix) != null)) {
            prefix = null;
        }
        if (prefix == null && (prefix = this.prefixTable.get(uri)) != null && ((!isElement || defaultNS != null) && "".equals(prefix) || this.nsSupport.getURI(prefix) != null)) {
            prefix = null;
        }
        if (prefix == null && qName != null && !"".equals(qName)) {
            int i = qName.indexOf(58);
            if (i == -1) {
                if (isElement && defaultNS == null) {
                    prefix = "";
                }
            } else {
                prefix = qName.substring(0, i);
            }
        }
        while (prefix == null || this.nsSupport.getURI(prefix) != null) {
            prefix = "__NS" + ++this.prefixCounter;
        }
        this.nsSupport.declarePrefix(prefix, uri);
        this.doneDeclTable.put(uri, prefix);
        return prefix;
    }

    public void emptyElement(String localName) throws SAXException {
        this.emptyElement("", localName, "", this.EMPTY_ATTS);
    }

    public void emptyElement(String uri, String localName) throws SAXException {
        this.emptyElement(uri, localName, "", this.EMPTY_ATTS);
    }

    public void emptyElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.isDataFormat()) {
            this.state = SEEN_ELEMENT;
            if (this.depth > 0) {
                this.characters(false, "\n");
            }
            this.doIndent();
        }
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(uri, localName, qName, true);
        this.writeAttributes(atts);
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write("/>");
        super.startElement(uri, localName, qName, atts);
        super.endElement(uri, localName, qName);
    }

    public void endDocument() throws SAXException {
        this.write('\n');
        super.endDocument();
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String localName) throws SAXException {
        this.endElement("", localName, "");
    }

    public void endElement(String uri, String localName) throws SAXException {
        this.endElement(uri, localName, "");
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isDataFormat()) {
            --this.depth;
            if (this.state == SEEN_ELEMENT) {
                this.characters(false, "\n");
                this.doIndent();
            }
        }
        this.write("</");
        this.writeName(uri, localName, qName, true);
        this.write('>');
        if (this.elementLevel == 1) {
            this.write('\n');
        }
        super.endElement(uri, localName, qName);
        this.nsSupport.popContext();
        --this.elementLevel;
        if (this.isDataFormat()) {
            this.state = this.stateStack.pop();
        }
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void forceNSDecl(String uri) {
        this.forcedDeclTable.put(uri, Boolean.TRUE);
    }

    public void forceNSDecl(String uri, String prefix) {
        this.setPrefix(uri, prefix);
        this.forceNSDecl(uri);
    }

    private void forceNSDecls() {
        for (String prefix : this.forcedDeclTable.keySet()) {
            this.doPrefix(prefix, null, true);
        }
    }

    public int getIndentStep() {
        return this.indentStep;
    }

    public String getPrefix(String uri) {
        return this.prefixTable.get(uri);
    }

    public Writer getWriter() {
        return this.output;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.writeEsc(ch, start, length, false);
        super.ignorableWhitespace(ch, start, length);
    }

    private void init(Writer writer) {
        this.setOutput(writer);
        this.nsSupport = new NamespaceSupport();
        this.prefixTable = new TreeMap<String, String>();
        this.forcedDeclTable = new TreeMap<String, Boolean>();
        this.doneDeclTable = new TreeMap<String, String>();
    }

    public boolean isDataFormat() {
        return this.dataFormat;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.write("<?");
        this.write(target);
        this.write(' ');
        this.write(data);
        this.write("?>");
        if (this.elementLevel < 1) {
            this.write('\n');
        }
        super.processingInstruction(target, data);
    }

    public void reset() {
        if (this.isDataFormat()) {
            this.depth = 0;
            this.state = SEEN_NOTHING;
            this.stateStack = new Stack();
        }
        this.elementLevel = 0;
        this.prefixCounter = 0;
        this.nsSupport.reset();
    }

    public void setDataFormat(boolean dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setIndentStep(int indentStep) {
        this.indentStep = indentStep;
    }

    public void setOutput(Writer writer) {
        this.output = writer == null ? new OutputStreamWriter(System.out) : writer;
    }

    public void setPrefix(String uri, String prefix) {
        this.prefixTable.put(uri, prefix);
    }

    public void startDocument() throws SAXException {
        this.reset();
        this.write("<?xml version=\"1.0\" standalone='yes'?>\n\n");
        super.startDocument();
    }

    public void startElement(String localName) throws SAXException {
        this.startElement("", localName, "", this.EMPTY_ATTS);
    }

    public void startElement(String uri, String localName) throws SAXException {
        this.startElement(uri, localName, "", this.EMPTY_ATTS);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.isDataFormat()) {
            this.stateStack.push(SEEN_ELEMENT);
            this.state = SEEN_NOTHING;
            if (this.depth > 0) {
                this.characters("\n");
            }
            this.doIndent();
        }
        ++this.elementLevel;
        this.nsSupport.pushContext();
        this.write('<');
        this.writeName(uri, localName, qName, true);
        this.writeAttributes(atts);
        if (this.elementLevel == 1) {
            this.forceNSDecls();
        }
        this.writeNSDecls();
        this.write('>');
        super.startElement(uri, localName, qName, atts);
        if (this.isDataFormat()) {
            ++this.depth;
        }
    }

    private void write(char c) throws SAXException {
        try {
            this.output.write(c);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void write(String s) throws SAXException {
        try {
            this.output.write(s);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void writeAttributes(Attributes atts) throws SAXException {
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            if (!"xmlns".equals(atts.getQName(i))) {
                char[] ch = atts.getValue(i).toCharArray();
                this.write(' ');
                this.writeName(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), false);
                this.write("=\"");
                this.writeEsc(ch, 0, ch.length, true);
                this.write('\"');
                continue;
            }
            this.forceNSDecl(atts.getValue(i));
        }
    }

    private void writeEsc(char[] ch, int start, int length, boolean isAttVal) throws SAXException {
        block6: for (int i = start; i < start + length; ++i) {
            switch (ch[i]) {
                case '&': {
                    this.write("&amp;");
                    continue block6;
                }
                case '<': {
                    this.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.write("&gt;");
                    continue block6;
                }
                case '\"': {
                    if (isAttVal) {
                        this.write("&quot;");
                        continue block6;
                    }
                    this.write('\"');
                    continue block6;
                }
                default: {
                    if (ch[i] > '\u007f') {
                        this.write("&#");
                        this.write(Integer.toString(ch[i]));
                        this.write(';');
                        continue block6;
                    }
                    this.write(ch[i]);
                }
            }
        }
    }

    private void writeName(String uri, String localName, String qName, boolean isElement) throws SAXException {
        String prefix = this.doPrefix(uri, qName, isElement);
        if (prefix != null && !"".equals(prefix)) {
            this.write(prefix);
            this.write(':');
        }
        this.write(localName);
    }

    private void writeNSDecls() throws SAXException {
        Enumeration<String> prefixes = this.nsSupport.getDeclaredPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            String uri = this.nsSupport.getURI(prefix);
            if (uri == null) {
                uri = "";
            }
            char[] ch = uri.toCharArray();
            this.write(' ');
            if ("".equals(prefix)) {
                this.write("xmlns=\"");
            } else {
                this.write("xmlns:");
                this.write(prefix);
                this.write("=\"");
            }
            this.writeEsc(ch, 0, ch.length, true);
            this.write('\"');
        }
    }
}

