/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.component;

import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.engine.component.ClientRoute;
import org.restlet.routing.Route;
import org.restlet.routing.Router;

public class ClientRouter
extends Router {
    private volatile Component component;

    public ClientRouter(Component component) {
        super(component == null ? null : component.getContext().createChildContext());
        this.component = component;
    }

    protected void logRoute(Route route) {
        if (this.getLogger().isLoggable(Level.FINE)) {
            if (route instanceof ClientRoute) {
                Client client = ((ClientRoute)route).getClient();
                this.getLogger().fine("This client was selected: \"" + client.getProtocols() + "\"");
            } else {
                super.logRoute(route);
            }
        }
    }

    public Restlet getNext(Request request, Response response) {
        Restlet result = super.getNext(request, response);
        if (result == null) {
            this.getLogger().warning("The protocol used by this request is not declared in the list of client connectors. (" + request.getResourceRef().getSchemeProtocol() + ")");
        }
        return result;
    }

    private Component getComponent() {
        return this.component;
    }

    public synchronized void start() throws Exception {
        for (Client client : this.getComponent().getClients()) {
            this.getRoutes().add(new ClientRoute(this, client));
        }
        super.start();
    }
}

