/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.ServerInfo;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UniformResource {
    private volatile Context context;
    private volatile Request request;
    private volatile Response response;

    protected void doCatch(Throwable throwable) {
        this.getLogger().log(Level.INFO, "Exception or error caught it resource", throwable);
        if (this.getResponse() != null && this.getApplication() != null) {
            this.getResponse().setStatus(this.getApplication().getStatusService().getStatus(throwable, this));
        }
    }

    protected void doInit() throws ResourceException {
    }

    protected void doRelease() throws ResourceException {
    }

    public Set<Method> getAllowedMethods() {
        return this.getResponse().getAllowedMethods();
    }

    public Application getApplication() {
        Application result = Application.getCurrent();
        return result == null ? new Application(this.getContext()) : result;
    }

    public List<ChallengeRequest> getChallengeRequests() {
        return this.getResponse().getChallengeRequests();
    }

    public ChallengeResponse getChallengeResponse() {
        return this.getRequest().getChallengeResponse();
    }

    public ClientInfo getClientInfo() {
        return this.getRequest().getClientInfo();
    }

    public Conditions getConditions() {
        return this.getRequest().getConditions();
    }

    public Context getContext() {
        return this.context;
    }

    public Series<Cookie> getCookies() {
        return this.getRequest().getCookies();
    }

    public Series<CookieSetting> getCookieSettings() {
        return this.getResponse().getCookieSettings();
    }

    public Set<Dimension> getDimensions() {
        return this.getResponse().getDimensions();
    }

    public Reference getHostRef() {
        return this.getRequest().getHostRef();
    }

    public Reference getLocationRef() {
        return this.getResponse().getLocationRef();
    }

    public Logger getLogger() {
        return this.getContext() != null ? this.getContext().getLogger() : Context.getCurrentLogger();
    }

    public Form getMatrix() {
        return this.getReference().getMatrixAsForm();
    }

    public Method getMethod() {
        return this.getRequest().getMethod();
    }

    public Reference getOriginalRef() {
        return this.getRequest().getOriginalRef();
    }

    public Protocol getProtocol() {
        return this.getRequest().getProtocol();
    }

    public Form getQuery() {
        return this.getReference().getQueryAsForm();
    }

    public List<Range> getRanges() {
        return this.getRequest().getRanges();
    }

    public Reference getReference() {
        return this.getRequest() == null ? null : this.getRequest().getResourceRef();
    }

    public Reference getReferrerRef() {
        return this.getRequest().getReferrerRef();
    }

    public Request getRequest() {
        return this.request;
    }

    public Map<String, Object> getRequestAttributes() {
        return this.getRequest().getAttributes();
    }

    public Representation getRequestEntity() {
        return this.getRequest().getEntity();
    }

    public Response getResponse() {
        return this.response;
    }

    public Map<String, Object> getResponseAttributes() {
        return this.getResponse().getAttributes();
    }

    public Representation getResponseEntity() {
        return this.getResponse().getEntity();
    }

    public Reference getRootRef() {
        return this.getRequest().getRootRef();
    }

    public ServerInfo getServerInfo() {
        return this.getResponse().getServerInfo();
    }

    public Status getStatus() {
        return this.getResponse().getStatus();
    }

    public abstract Representation handle();

    public final void init(Context context, Request request, Response response) {
        this.context = context;
        this.request = request;
        this.response = response;
        try {
            this.doInit();
        }
        catch (Throwable t) {
            this.doCatch(t);
        }
    }

    public boolean isConfidential() {
        return this.getRequest().isConfidential();
    }

    public final void release() {
        try {
            this.doRelease();
        }
        catch (Throwable t) {
            this.doCatch(t);
        }
    }
}

