/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.engine.security.DefaultJaasCallbackHandler;
import org.restlet.security.Verifier;

public class JaasVerifier
extends Verifier {
    private volatile Configuration configuration;
    private volatile String name;

    public JaasVerifier(String name) {
        this.name = name;
    }

    protected CallbackHandler createCallbackHandler(Request request, Response response) {
        return new DefaultJaasCallbackHandler(request, response);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setName(String contextName) {
        this.name = contextName;
    }

    public int verify(Request request, Response response) {
        int result = 4;
        try {
            LoginContext loginContext = new LoginContext(this.getName(), request.getClientInfo().getSubject(), this.createCallbackHandler(request, response), this.getConfiguration());
            loginContext.login();
        }
        catch (LoginException le) {
            result = -1;
        }
        return result;
    }
}

