/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Message;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Cookie;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Reference;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request
extends Message {
    private volatile ChallengeResponse challengeResponse;
    private volatile ChallengeResponse proxyChallengeResponse;
    private volatile ClientInfo clientInfo;
    private volatile Conditions conditions;
    private volatile Series<Cookie> cookies;
    private volatile Reference hostRef;
    private volatile Method method;
    private volatile Reference originalRef;
    private volatile List<Range> ranges;
    private volatile Reference referrerRef;
    private volatile Reference resourceRef;
    private volatile Reference rootRef;

    public static Request getCurrent() {
        return Response.getCurrent() == null ? null : Response.getCurrent().getRequest();
    }

    public Request() {
    }

    public Request(Method method, Reference resourceRef) {
        this(method, resourceRef, null);
    }

    public Request(Method method, Reference resourceRef, Representation entity) {
        super(entity);
        this.setMethod(method);
        this.setResourceRef(resourceRef);
    }

    public Request(Method method, String resourceUri) {
        this(method, new Reference(resourceUri));
    }

    public Request(Method method, String resourceUri, Representation entity) {
        this(method, new Reference(resourceUri), entity);
    }

    public ChallengeResponse getChallengeResponse() {
        return this.challengeResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInfo getClientInfo() {
        ClientInfo c = this.clientInfo;
        if (c == null) {
            Request request = this;
            synchronized (request) {
                c = this.clientInfo;
                if (c == null) {
                    this.clientInfo = c = new ClientInfo();
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conditions getConditions() {
        Conditions c = this.conditions;
        if (c == null) {
            Request request = this;
            synchronized (request) {
                c = this.conditions;
                if (c == null) {
                    this.conditions = c = new Conditions();
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Series<Cookie> getCookies() {
        CookieSeries c = this.cookies;
        if (c == null) {
            Request request = this;
            synchronized (request) {
                c = this.cookies;
                if (c == null) {
                    this.cookies = c = new CookieSeries();
                }
            }
        }
        return c;
    }

    public Reference getHostRef() {
        return this.hostRef;
    }

    public Method getMethod() {
        return this.method;
    }

    public Reference getOriginalRef() {
        return this.originalRef;
    }

    public Protocol getProtocol() {
        Protocol result = null;
        if (this.getResourceRef() != null && (result = this.getResourceRef().getSchemeProtocol()) == null) {
            result = this.getResourceRef().getBaseRef() != null ? this.getResourceRef().getBaseRef().getSchemeProtocol() : null;
        }
        return result;
    }

    public ChallengeResponse getProxyChallengeResponse() {
        return this.proxyChallengeResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Range> getRanges() {
        List<Range> r = this.ranges;
        if (r == null) {
            Request request = this;
            synchronized (request) {
                r = this.ranges;
                if (r == null) {
                    this.ranges = r = new CopyOnWriteArrayList<Range>();
                }
            }
        }
        return r;
    }

    public Reference getReferrerRef() {
        return this.referrerRef;
    }

    public Reference getResourceRef() {
        return this.resourceRef;
    }

    public Reference getRootRef() {
        return this.rootRef;
    }

    @Override
    public boolean isConfidential() {
        return this.getProtocol() == null ? false : this.getProtocol().isConfidential();
    }

    @Override
    public boolean isEntityAvailable() {
        boolean result;
        boolean bl = result = Method.GET.equals(this.getMethod()) || Method.HEAD.equals(this.getMethod()) || Method.DELETE.equals(this.getMethod());
        if (result) {
            return false;
        }
        return super.isEntityAvailable();
    }

    public void setChallengeResponse(ChallengeResponse challengeResponse) {
        this.challengeResponse = challengeResponse;
    }

    public void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public void setCookies(Series<Cookie> cookies) {
        this.cookies = cookies;
    }

    public void setHostRef(Reference hostRef) {
        this.hostRef = hostRef;
    }

    public void setHostRef(String hostUri) {
        this.setHostRef(new Reference(hostUri));
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setOriginalRef(Reference originalRef) {
        this.originalRef = originalRef;
    }

    public void setProxyChallengeResponse(ChallengeResponse challengeResponse) {
        this.proxyChallengeResponse = challengeResponse;
    }

    public void setRanges(List<Range> ranges) {
        this.ranges = ranges;
    }

    public void setReferrerRef(Reference referrerRef) {
        this.referrerRef = referrerRef;
        if (this.referrerRef != null && this.referrerRef.getFragment() != null) {
            this.referrerRef.setFragment(null);
        }
    }

    public void setReferrerRef(String referrerUri) {
        this.setReferrerRef(new Reference(referrerUri));
    }

    public void setResourceRef(Reference resourceRef) {
        this.resourceRef = resourceRef;
    }

    public void setResourceRef(String resourceUri) {
        if (this.getResourceRef() != null) {
            this.setResourceRef(new Reference(this.getResourceRef().getBaseRef(), resourceUri));
        } else {
            this.setResourceRef(new Reference(resourceUri));
        }
    }

    public void setRootRef(Reference rootRef) {
        this.rootRef = rootRef;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CookieSeries
    extends Series<Cookie> {
        public CookieSeries() {
        }

        public CookieSeries(List<Cookie> delegate) {
            super(delegate);
        }

        @Override
        public Cookie createEntry(String name, String value) {
            return new Cookie(name, value);
        }

        @Override
        public Series<Cookie> createSeries(List<Cookie> delegate) {
            if (delegate != null) {
                return new CookieSeries(delegate);
            }
            return new CookieSeries();
        }
    }
}

