/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.Arrays;
import java.util.List;
import org.restlet.Connector;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.engine.Engine;
import org.restlet.engine.RestletHelper;
import org.restlet.resource.Finder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends Connector {
    private volatile String address;
    private final RestletHelper<Server> helper;
    private volatile int port;
    private volatile Restlet target;

    public Server(Context context, List<Protocol> protocols, int port, Restlet target) {
        this(context, protocols, null, port, target);
    }

    public Server(Context context, List<Protocol> protocols, String address, int port, Restlet target) {
        this(context, protocols, address, port, target, null);
    }

    public Server(Context context, List<Protocol> protocols, String address, int port, Restlet target, String helperClass) {
        super(context, protocols);
        this.address = address;
        this.port = port;
        this.target = target;
        this.helper = Engine.getInstance() != null ? Engine.getInstance().createHelper(this, helperClass) : null;
    }

    public Server(Context context, Protocol protocol, int port, Restlet target) {
        this(context, protocol, null, port, target);
    }

    public Server(Context context, Protocol protocol, Restlet target) {
        this(context, protocol, null, protocol == null ? -1 : protocol.getDefaultPort(), target);
    }

    public Server(Context context, Protocol protocol, String address, int port, Restlet target) {
        this(context, protocol == null ? null : Arrays.asList(protocol), address, port, target);
    }

    public Server(List<Protocol> protocols, int port, Restlet target) {
        this(null, protocols, port, target);
    }

    public Server(List<Protocol> protocols, String address, int port, Restlet target) {
        this(null, protocols, address, port, target);
    }

    public Server(Protocol protocol, int port, Class<?> targetClass) {
        this(null, protocol, port, (Restlet)new Finder(Context.getCurrent(), targetClass));
    }

    public Server(Protocol protocol, int port, Restlet target) {
        this(null, protocol, port, target);
    }

    public Server(Protocol protocol, Restlet target) {
        this(null, protocol, target);
    }

    public Server(Protocol protocol, String address, int port, Restlet target) {
        this(null, protocol, address, port, target);
    }

    public Server(Protocol protocol, String address, Restlet target) {
        this(null, protocol, address, protocol.getDefaultPort(), target);
    }

    public String getAddress() {
        return this.address;
    }

    public int getEphemeralPort() {
        return (Integer)this.getHelper().getAttributes().get("ephemeralPort");
    }

    private RestletHelper<Server> getHelper() {
        return this.helper;
    }

    public int getPort() {
        return this.port;
    }

    public Restlet getTarget() {
        return this.target;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getTarget() != null) {
            this.getTarget().handle(request, response);
        }
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public boolean isAvailable() {
        return this.getHelper() != null;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setNext(Class<?> targetClass) {
        this.setTarget(new Finder(this.getContext(), targetClass));
    }

    protected void setPort(int port) {
        this.port = port;
    }

    public void setTarget(Restlet target) {
        this.target = target;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            super.start();
            if (this.getHelper() != null) {
                this.getHelper().start();
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            if (this.getHelper() != null) {
                this.getHelper().stop();
            }
            super.stop();
        }
    }
}

