/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.data.Product;
import org.restlet.engine.Engine;
import org.restlet.engine.http.UserAgentUtils;
import org.restlet.engine.util.ConnegUtils;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;
import org.restlet.routing.Template;
import org.restlet.routing.Variable;
import org.restlet.security.Role;
import org.restlet.security.RolePrincipal;
import org.restlet.service.MetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientInfo {
    private static List<String> userAgentTemplates = null;
    private volatile List<Preference<CharacterSet>> acceptedCharacterSets = null;
    private volatile List<Preference<Encoding>> acceptedEncodings = null;
    private volatile List<Preference<Language>> acceptedLanguages = null;
    private volatile List<Preference<MediaType>> acceptedMediaTypes = null;
    private volatile String address = null;
    private volatile String agent = null;
    private volatile Map<String, String> agentAttributes;
    private volatile Product agentMainProduct;
    private volatile List<Product> agentProducts = null;
    private volatile boolean authenticated;
    private volatile List<String> forwardedAddresses = null;
    private volatile int port = -1;
    private volatile Subject subject = new Subject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> getUserAgentTemplates() {
        List<String> u = userAgentTemplates;
        if (u != null) return u;
        Class<ClientInfo> clazz = ClientInfo.class;
        synchronized (ClientInfo.class) {
            URL userAgentPropertiesUrl;
            u = userAgentTemplates;
            if (u != null || (userAgentPropertiesUrl = Engine.getClassLoader().getResource("org/restlet/data/agent.properties")) == null) return u;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(userAgentPropertiesUrl.openStream(), CharacterSet.UTF_8.getName()));
                String line = reader.readLine();
                while (line != null) {
                    if (line.trim().length() > 0 && !line.trim().startsWith("#")) {
                        if (u == null) {
                            u = new ArrayList<String>();
                        }
                        u.add(line);
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (IOException e) {
                if (Context.getCurrent() == null) return u;
                Context.getCurrent().getLogger().warning("Cannot read '" + userAgentPropertiesUrl.toString() + "' due to: " + e.getMessage());
            }
            return u;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Preference<CharacterSet>> getAcceptedCharacterSets() {
        List<Preference<CharacterSet>> a = this.acceptedCharacterSets;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.acceptedCharacterSets;
                if (a == null) {
                    this.acceptedCharacterSets = a = new ArrayList<Preference<CharacterSet>>();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Preference<Encoding>> getAcceptedEncodings() {
        List<Preference<Encoding>> a = this.acceptedEncodings;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.acceptedEncodings;
                if (a == null) {
                    this.acceptedEncodings = a = new ArrayList<Preference<Encoding>>();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Preference<Language>> getAcceptedLanguages() {
        List<Preference<Language>> a = this.acceptedLanguages;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.acceptedLanguages;
                if (a == null) {
                    this.acceptedLanguages = a = new ArrayList<Preference<Language>>();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Preference<MediaType>> getAcceptedMediaTypes() {
        List<Preference<MediaType>> a = this.acceptedMediaTypes;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.acceptedMediaTypes;
                if (a == null) {
                    this.acceptedMediaTypes = a = new ArrayList<Preference<MediaType>>();
                }
            }
        }
        return a;
    }

    public String getAddress() {
        return this.address;
    }

    @Deprecated
    public List<String> getAddresses() {
        return this.getForwardedAddresses();
    }

    public String getAgent() {
        return this.agent;
    }

    public Map<String, String> getAgentAttributes() {
        if (this.agentAttributes == null) {
            this.agentAttributes = new HashMap<String, String>();
            HashMap<String, Object> map = new HashMap<String, Object>();
            Template template = null;
            Variable agentName = new Variable(7);
            Variable agentVersion = new Variable(7);
            Variable agentComment = new Variable(4);
            Variable agentCommentAttribute = new Variable(5);
            Variable facultativeData = new Variable(1, null, false, false);
            for (String string : ClientInfo.getUserAgentTemplates()) {
                template = new Template(string, 2);
                template.getVariables().put("agentName", agentName);
                template.getVariables().put("agentVersion", agentVersion);
                template.getVariables().put("agentComment", agentComment);
                template.getVariables().put("agentOs", agentCommentAttribute);
                template.getVariables().put("commentAttribute", agentCommentAttribute);
                template.getVariables().put("facultativeData", facultativeData);
                if (template.parse(this.getAgent(), map) <= -1) continue;
                for (String key : map.keySet()) {
                    this.agentAttributes.put(key, (String)map.get(key));
                }
            }
        }
        return this.agentAttributes;
    }

    public String getAgentName() {
        Product product = this.getMainAgentProduct();
        if (product != null) {
            return product.getName();
        }
        return null;
    }

    public List<Product> getAgentProducts() {
        if (this.agentProducts == null) {
            this.agentProducts = UserAgentUtils.parse(this.getAgent());
        }
        return this.agentProducts;
    }

    public String getAgentVersion() {
        Product product = this.getMainAgentProduct();
        if (product != null) {
            return product.getVersion();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getForwardedAddresses() {
        List<String> a = this.forwardedAddresses;
        if (a == null) {
            ClientInfo clientInfo = this;
            synchronized (clientInfo) {
                a = this.forwardedAddresses;
                if (a == null) {
                    this.forwardedAddresses = a = new ArrayList<String>();
                }
            }
        }
        return a;
    }

    public Product getMainAgentProduct() {
        if (this.agentMainProduct == null && this.getAgentAttributes() != null) {
            this.agentMainProduct = new Product(this.getAgentAttributes().get("agentName"), this.getAgentAttributes().get("agentVersion"), this.getAgentAttributes().get("agentComment"));
        }
        return this.agentMainProduct;
    }

    public int getPort() {
        return this.port;
    }

    public CharacterSet getPreferredCharacterSet(List<CharacterSet> supported) {
        return ConnegUtils.getPreferredMetadata(supported, this.getAcceptedCharacterSets());
    }

    public Encoding getPreferredEncoding(List<Encoding> supported) {
        return ConnegUtils.getPreferredMetadata(supported, this.getAcceptedEncodings());
    }

    public Language getPreferredLanguage(List<Language> supported) {
        return ConnegUtils.getPreferredMetadata(supported, this.getAcceptedLanguages());
    }

    public MediaType getPreferredMediaType(List<MediaType> supported) {
        return ConnegUtils.getPreferredMetadata(supported, this.getAcceptedMediaTypes());
    }

    public Variant getPreferredVariant(List<Variant> variants, MetadataService metadataService) {
        return ConnegUtils.getPreferredVariant(this, variants, metadataService);
    }

    @Deprecated
    public Variant getPreferredVariant(Resource resource, MetadataService metadataService) {
        return this.getPreferredVariant(resource.getVariants(), metadataService);
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getUpstreamAddress() {
        if (this.forwardedAddresses == null || this.forwardedAddresses.isEmpty()) {
            return this.getAddress();
        }
        return this.forwardedAddresses.get(0);
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isInRole(Role role) {
        for (Principal principal : this.getSubject().getPrincipals()) {
            RolePrincipal rolePrincipal;
            if (!(principal instanceof RolePrincipal) || !(rolePrincipal = (RolePrincipal)principal).matches(role)) continue;
            return true;
        }
        return false;
    }

    public void setAcceptedCharacterSets(List<Preference<CharacterSet>> acceptedCharacterSets) {
        this.acceptedCharacterSets = acceptedCharacterSets;
    }

    public void setAcceptedEncodings(List<Preference<Encoding>> acceptedEncodings) {
        this.acceptedEncodings = acceptedEncodings;
    }

    public void setAcceptedLanguages(List<Preference<Language>> acceptedLanguages) {
        this.acceptedLanguages = acceptedLanguages;
    }

    public void setAcceptedMediaTypes(List<Preference<MediaType>> acceptedMediaTypes) {
        this.acceptedMediaTypes = acceptedMediaTypes;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Deprecated
    public void setAddresses(List<String> addresses) {
        this.setForwardedAddresses(addresses);
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setForwardedAddresses(List<String> forwardedAddresses) {
        this.forwardedAddresses = forwardedAddresses;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }
}

