/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.engine.Engine;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.security.Guard;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticatorUtils {
    private static final Pattern PATTERN_RFC_2617 = Pattern.compile("([^=]+)=\"?([^\",]+)(?:\"\\s*)?,?\\s*");

    public static boolean anyNull(Object ... objects) {
        for (Object o : objects) {
            if (o != null) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static int authenticate(Request request, Guard guard) {
        ChallengeResponse cr;
        int result = 0;
        if (guard.getScheme() != null && (cr = request.getChallengeResponse()) != null && guard.getScheme().equals(cr.getScheme())) {
            AuthenticatorHelper helper = Engine.getInstance().findHelper(cr.getScheme(), false, true);
            if (helper != null) {
                result = helper.authenticate(cr, request, guard);
            } else {
                throw new IllegalArgumentException("Challenge scheme " + guard.getScheme() + " not supported by the Restlet engine.");
            }
        }
        if (request.getChallengeResponse() != null) {
            request.getChallengeResponse().setAuthenticated(result == 1);
        }
        request.getClientInfo().setAuthenticated(result == 1);
        return result;
    }

    @Deprecated
    public static void challenge(Response response, boolean stale, Guard guard) {
        AuthenticatorHelper helper = Engine.getInstance().findHelper(guard.getScheme(), false, true);
        if (helper == null) {
            throw new IllegalArgumentException("Challenge scheme " + guard.getScheme() + " not supported by the Restlet engine.");
        }
        helper.challenge(response, stale, guard);
    }

    public static String format(ChallengeRequest request) {
        String result = null;
        if (request != null) {
            AuthenticatorHelper helper = Engine.getInstance().findHelper(request.getScheme(), false, true);
            if (helper != null) {
                result = helper.format(request);
            } else {
                result = "?";
                Context.getCurrentLogger().warning("Challenge scheme " + request.getScheme() + " not supported by the Restlet engine.");
            }
        }
        return result;
    }

    public static String format(ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        String result = null;
        AuthenticatorHelper helper = Engine.getInstance().findHelper(challenge.getScheme(), true, false);
        if (helper != null) {
            result = helper.format(challenge, request, httpHeaders);
        } else {
            result = "?";
            Context.getCurrentLogger().warning("Challenge scheme " + challenge.getScheme() + " not supported by the Restlet engine.");
        }
        return result;
    }

    public static ChallengeRequest parseAuthenticateHeader(String header) {
        AuthenticatorHelper helper;
        ChallengeRequest result = null;
        if (header != null) {
            int space = header.indexOf(32);
            if (space != -1) {
                String scheme = header.substring(0, space);
                result = new ChallengeRequest(new ChallengeScheme("HTTP_" + scheme, scheme), null);
                String rest = header.substring(space + 1);
                AuthenticatorUtils.parseParameters(rest, result.getParameters());
                result.setRealm(result.getParameters().getFirstValue("realm"));
            } else {
                String scheme = header.substring(0);
                result = new ChallengeRequest(new ChallengeScheme("HTTP_" + scheme, scheme), null);
            }
        }
        if ((helper = Engine.getInstance().findHelper(result.getScheme(), true, false)) != null) {
            helper.parseRequest(result, header);
        } else {
            Context.getCurrentLogger().warning("Challenge scheme " + result.getScheme() + " not supported by the Restlet engine.");
        }
        return result;
    }

    public static ChallengeResponse parseAuthorizationHeader(Request request, String header) {
        int space;
        ChallengeResponse result = null;
        if (header != null && (space = header.indexOf(32)) != -1) {
            String scheme = header.substring(0, space);
            String credentials = header.substring(space + 1);
            result = new ChallengeResponse(new ChallengeScheme("HTTP_" + scheme, scheme), credentials);
            AuthenticatorHelper helper = Engine.getInstance().findHelper(result.getScheme(), true, false);
            if (helper != null) {
                helper.parseResponse(result, request);
            } else {
                Context.getCurrentLogger().warning("Challenge scheme " + result.getScheme() + " not supported by the Restlet engine.");
            }
        }
        return result;
    }

    public static void parseParameters(String paramString, Series<Parameter> parameters) {
        Matcher matcher = PATTERN_RFC_2617.matcher(paramString);
        while (matcher.find() && matcher.groupCount() == 2) {
            parameters.add(matcher.group(1), matcher.group(2));
        }
    }

    private AuthenticatorUtils() {
    }
}

