/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.engine.io.ByteUtils;
import org.restlet.representation.ChannelRepresentation;

public class ReadableRepresentation
extends ChannelRepresentation {
    private volatile ReadableByteChannel channel;

    public ReadableRepresentation(ReadableByteChannel readableChannel, MediaType mediaType) {
        this(readableChannel, mediaType, -1L);
    }

    public ReadableRepresentation(ReadableByteChannel channel, MediaType mediaType, long expectedSize) {
        super(mediaType);
        this.setSize(expectedSize);
        this.channel = channel;
        this.setAvailable(channel != null);
        this.setTransient(true);
    }

    public ReadableByteChannel getChannel() throws IOException {
        ReadableByteChannel result = this.channel;
        this.setAvailable(false);
        return result;
    }

    public void release() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Error while releasing the representation.", e);
            }
            this.channel = null;
        }
        super.release();
    }

    public void setChannel(ReadableByteChannel channel) {
        this.channel = channel;
    }

    public void write(WritableByteChannel writableChannel) throws IOException {
        ByteUtils.write(this.getChannel(), writableChannel);
    }
}

