/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.security.Authorizer;
import org.restlet.security.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleAuthorizer
extends Authorizer {
    private final List<Role> authorizedRoles = new CopyOnWriteArrayList<Role>();
    private final List<Role> forbiddenRoles = new CopyOnWriteArrayList<Role>();

    public RoleAuthorizer() {
        this((String)null);
    }

    public RoleAuthorizer(String identifier) {
        super(identifier);
    }

    @Override
    public boolean authorize(Request request, Response response) {
        boolean authorized = false;
        boolean forbidden = false;
        if (this.getAuthorizedRoles().isEmpty()) {
            authorized = true;
        } else {
            for (Role authorizedRole : this.getAuthorizedRoles()) {
                authorized = authorized || request.getClientInfo().isInRole(authorizedRole);
            }
        }
        for (Role forbiddenRole : this.getForbiddenRoles()) {
            forbidden = forbidden || request.getClientInfo().isInRole(forbiddenRole);
        }
        return authorized && !forbidden;
    }

    public List<Role> getAuthorizedRoles() {
        return this.authorizedRoles;
    }

    public List<Role> getForbiddenRoles() {
        return this.forbiddenRoles;
    }
}

