/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.Edition;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.io.NbChannelInputStream;
import org.restlet.engine.io.NbChannelOutputStream;
import org.restlet.engine.io.SelectorFactory;
import org.restlet.representation.Representation;

public class NioUtils {
    public static final int NIO_TIMEOUT = 60000;

    public static void copy(FileChannel fileChannel, WritableByteChannel writableChannel) throws IOException {
        long position = 0L;
        long count = fileChannel.size();
        long written = 0L;
        SelectableChannel selectableChannel = null;
        if (writableChannel instanceof SelectableChannel) {
            selectableChannel = (SelectableChannel)((Object)writableChannel);
        }
        while (count > 0L) {
            NioUtils.waitForState(selectableChannel, 4);
            written = fileChannel.transferTo(position, count, writableChannel);
            position += written;
            count -= written;
        }
    }

    public static void copy(ReadableByteChannel readableChannel, OutputStream outputStream) throws IOException {
        if (readableChannel != null && outputStream != null) {
            BioUtils.copy((InputStream)new NbChannelInputStream(readableChannel), outputStream);
        }
    }

    public static void copy(ReadableByteChannel readableChannel, WritableByteChannel writableChannel) throws IOException {
        if (readableChannel != null && writableChannel != null) {
            BioUtils.copy((InputStream)new NbChannelInputStream(readableChannel), new NbChannelOutputStream(writableChannel));
        }
    }

    public static ReadableByteChannel getChannel(InputStream inputStream) {
        return inputStream != null ? Channels.newChannel(inputStream) : null;
    }

    public static WritableByteChannel getChannel(OutputStream outputStream) {
        return outputStream != null ? Channels.newChannel(outputStream) : null;
    }

    public static ReadableByteChannel getChannel(Representation representation) throws IOException {
        ReadableByteChannel result = null;
        if (Edition.CURRENT == Edition.GAE) {
            Context.getCurrentLogger().log(Level.WARNING, "The GAE edition is unable to return a channel for a representation given its write(WritableByteChannel) method.");
        }
        return result;
    }

    public static InputStream getStream(ReadableByteChannel readableChannel) {
        NbChannelInputStream result = null;
        if (readableChannel != null) {
            result = new NbChannelInputStream(readableChannel);
        }
        return result;
    }

    public static OutputStream getStream(WritableByteChannel writableChannel) {
        return NioUtils.isBlocking(writableChannel) ? Channels.newOutputStream(writableChannel) : new NbChannelOutputStream(writableChannel);
    }

    public static boolean isBlocking(Channel channel) {
        boolean result = true;
        if (channel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)channel;
            result = selectableChannel.isBlocking();
        }
        return result;
    }

    public static void release(Selector selector, SelectionKey selectionKey) throws IOException {
        if (selectionKey != null) {
            selectionKey.cancel();
            if (selector != null) {
                selector.selectNow();
                SelectorFactory.returnSelector(selector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForState(SelectableChannel selectableChannel, int operations) throws IOException {
        if (selectableChannel != null) {
            Selector selector = null;
            SelectionKey selectionKey = null;
            int selected = 0;
            try {
                selector = SelectorFactory.getSelector();
                while (selected == 0) {
                    selectionKey = selectableChannel.register(selector, operations);
                    selected = selector.select(60000L);
                }
            }
            finally {
                NioUtils.release(selector, selectionKey);
            }
        }
    }

    private NioUtils() {
    }
}

