/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.io.BufferProcessor;
import org.restlet.engine.io.BufferState;
import org.restlet.engine.io.NioUtils;

public class Buffer {
    private final ByteBuffer bytes;
    private volatile int fillBegin = 0;
    private volatile BufferState state;

    private static ByteBuffer createByteBuffer(int bufferSize, boolean direct) {
        ByteBuffer result = null;
        result = direct ? ByteBuffer.allocateDirect(bufferSize) : ByteBuffer.allocate(bufferSize);
        return result;
    }

    public Buffer(ByteBuffer byteBuffer) {
        this(byteBuffer, BufferState.FILLING);
    }

    public Buffer(ByteBuffer byteBuffer, BufferState byteBufferState) {
        this.bytes = byteBuffer;
        this.state = byteBufferState;
    }

    public Buffer(int bufferSize) {
        this(bufferSize, false);
    }

    public Buffer(int bufferSize, boolean direct) {
        this(Buffer.createByteBuffer(bufferSize, direct));
    }

    public void beforeDrain() {
        if (this.isFilling()) {
            this.flip();
        }
    }

    public void beforeFill() {
        if (this.isDraining()) {
            this.flip();
        }
    }

    public boolean canCompact() {
        return this.isFilling() ? this.fillBegin > 0 : this.getBytes().position() > 0;
    }

    public boolean canDrain() {
        return this.isDraining() && this.hasRemaining();
    }

    public boolean canFill() {
        return this.isFilling() && this.hasRemaining();
    }

    public final int capacity() {
        return this.getBytes().capacity();
    }

    public void clear() {
        this.fillBegin = 0;
        this.bytes.clear();
        this.state = BufferState.FILLING;
    }

    public void compact() {
        if (this.isDraining()) {
            this.getBytes().compact();
            this.getBytes().flip();
        } else {
            this.flip();
            this.compact();
            this.flip();
        }
    }

    public boolean couldDrain() {
        return this.isFilling() && this.getBytes().position() > this.fillBegin;
    }

    public boolean couldFill() {
        return this.isDraining() && (!this.hasRemaining() || this.getBytes().limit() < this.getBytes().capacity());
    }

    public int drain() {
        return this.getBytes().get() & 0xFF;
    }

    public void drain(byte[] targetArray, int offset, int length) {
        this.getBytes().get(targetArray, offset, length);
    }

    public int drain(ByteBuffer targetBuffer) {
        return this.drain(targetBuffer, 0L);
    }

    public int drain(ByteBuffer targetBuffer, long maxDrained) {
        return NioUtils.copy(this.getBytes(), targetBuffer, maxDrained);
    }

    public BufferState drain(StringBuilder lineBuilder, BufferState builderState) throws IOException {
        if (builderState == BufferState.IDLE) {
            builderState = BufferState.FILLING;
        }
        while (builderState != BufferState.DRAINING && this.getBytes().hasRemaining()) {
            byte next = this.getBytes().get();
            switch (builderState) {
                case FILLING: {
                    if (HeaderUtils.isCarriageReturn(next)) {
                        builderState = BufferState.FILLED;
                        break;
                    }
                    lineBuilder.append((char)next);
                    break;
                }
                case FILLED: {
                    if (HeaderUtils.isLineFeed(next)) {
                        builderState = BufferState.DRAINING;
                        break;
                    }
                    throw new IOException("Missing line feed character at the end of the line. Found character \"" + (char)next + "\" (" + next + ") instead");
                }
            }
        }
        return builderState;
    }

    public int drain(WritableByteChannel wbc) throws IOException {
        return wbc.write(this.getBytes());
    }

    public void fill(byte[] sourceBuffer) {
        this.getBytes().put(sourceBuffer);
    }

    public int fill(ByteBuffer sourceBuffer) {
        return this.fill(sourceBuffer, 0L);
    }

    public int fill(ByteBuffer sourceBuffer, long maxFilled) {
        return NioUtils.copy(sourceBuffer, this.getBytes(), maxFilled);
    }

    public int fill(ReadableByteChannel sourceChannel) throws IOException {
        int result = 0;
        if (sourceChannel.isOpen()) {
            result = sourceChannel.read(this.getBytes());
        }
        return result;
    }

    public void fill(String source) {
        this.fill(source.getBytes());
    }

    public void flip() {
        if (this.isFilling()) {
            this.setState(BufferState.DRAINING);
            this.getBytes().limit(this.getBytes().position());
            this.getBytes().position(this.fillBegin);
            this.fillBegin = 0;
        } else if (this.isDraining()) {
            if (this.hasRemaining()) {
                this.setState(BufferState.FILLING);
                this.fillBegin = this.getBytes().position();
                this.getBytes().position(this.getBytes().limit());
                this.getBytes().limit(this.getBytes().capacity());
            } else {
                this.clear();
            }
        }
    }

    public ByteBuffer getBytes() {
        return this.bytes;
    }

    public Object getLock() {
        return this.bytes;
    }

    public BufferState getState() {
        return this.state;
    }

    public final boolean hasRemaining() {
        return this.getBytes().hasRemaining();
    }

    public boolean isDraining() {
        return this.getState() == BufferState.DRAINING;
    }

    public boolean isEmpty() {
        return this.isFilling() ? this.capacity() == this.remaining() : !this.hasRemaining();
    }

    public boolean isFilling() {
        return this.getState() == BufferState.FILLING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(BufferProcessor processor, int maxDrained, Object ... args) throws IOException {
        int result = 0;
        Object object = this.getLock();
        synchronized (object) {
            int totalFilled = 0;
            int drained = 0;
            int filled = 0;
            boolean lastDrainFailed = false;
            boolean lastFillFailed = false;
            boolean fillEnded = false;
            boolean tryAgain = true;
            if (Context.getCurrentLogger().isLoggable(Level.FINEST)) {
                Context.getCurrentLogger().log(Level.FINEST, "Beginning process of buffer " + this);
            }
            while (tryAgain && processor.canLoop(this, args)) {
                if (this.isDraining()) {
                    if (Context.getCurrentLogger().isLoggable(Level.FINEST)) {
                        Context.getCurrentLogger().log(Level.FINEST, "Draining buffer " + this);
                    }
                    drained = 0;
                    if (this.hasRemaining()) {
                        if (maxDrained <= 0) {
                            drained = processor.onDrain(this, 0, args);
                        } else if (maxDrained > result) {
                            drained = processor.onDrain(this, maxDrained - result, args);
                        }
                    }
                    if (drained > 0) {
                        result += drained;
                        lastDrainFailed = false;
                        lastFillFailed = false;
                        if (!Context.getCurrentLogger().isLoggable(Level.FINEST)) continue;
                        Context.getCurrentLogger().log(Level.FINEST, drained + " bytes drained from buffer, " + this.remaining() + " remaining bytes");
                        continue;
                    }
                    if (!lastFillFailed) {
                        if (this.couldFill()) {
                            this.beforeFill();
                        } else if (this.canCompact()) {
                            this.compact();
                        } else {
                            tryAgain = false;
                        }
                    } else {
                        tryAgain = false;
                    }
                    lastDrainFailed = true;
                    continue;
                }
                if (this.isFilling()) {
                    if (Context.getCurrentLogger().isLoggable(Level.FINEST)) {
                        Context.getCurrentLogger().log(Level.FINEST, "Filling buffer " + this);
                    }
                    filled = 0;
                    if (this.hasRemaining() && processor.couldFill(this, args)) {
                        filled = processor.onFill(this, args);
                    }
                    if (filled > 0) {
                        totalFilled += filled;
                        lastDrainFailed = false;
                        lastFillFailed = false;
                        if (!Context.getCurrentLogger().isLoggable(Level.FINEST)) continue;
                        Context.getCurrentLogger().log(Level.FINEST, filled + " bytes filled into buffer");
                        continue;
                    }
                    if (!lastDrainFailed && this.couldDrain()) {
                        this.beforeDrain();
                    } else {
                        tryAgain = false;
                    }
                    if (filled == -1) {
                        fillEnded = true;
                        processor.onFillEof();
                    }
                    lastFillFailed = true;
                    continue;
                }
                tryAgain = false;
            }
            if (result == 0 && (!processor.couldFill(this, args) || fillEnded)) {
                result = -1;
            }
            if (Context.getCurrentLogger().isLoggable(Level.FINEST)) {
                Context.getCurrentLogger().log(Level.FINEST, "Ending process of buffer " + this + ". Result: " + result + ", try again: " + tryAgain + ", can loop: " + processor.canLoop(this, args));
            }
        }
        processor.onProcessed(result);
        return result;
    }

    public int process(BufferProcessor processor, Object ... args) throws IOException {
        return this.process(processor, 0, args);
    }

    public final int remaining() {
        return this.getBytes().remaining();
    }

    public void setState(BufferState byteBufferState) {
        this.state = byteBufferState;
    }

    public String toString() {
        return this.getBytes().toString() + ", " + (Object)((Object)this.getState()) + ", " + this.isEmpty();
    }
}

