/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.engine.Edition;
import org.restlet.util.WrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Series<E extends Parameter>
extends WrapperList<E> {
    public static final Object EMPTY_VALUE = new Object();

    public static Series<? extends Parameter> unmodifiableSeries(Series<? extends Parameter> series) {
        if (Edition.CURRENT != Edition.GWT) {
            return new Form(Collections.unmodifiableList(series.getDelegate()));
        }
        return new Form(series.getDelegate());
    }

    public Series() {
    }

    public Series(int initialCapacity) {
        super(initialCapacity);
    }

    public Series(List<E> delegate) {
        super(delegate);
    }

    public boolean add(String name, String value) {
        return this.add(this.createEntry(name, value));
    }

    public void copyTo(Map<String, Object> params) {
        Object currentValue = null;
        for (Parameter param : this) {
            if (!params.containsKey(param.getName())) continue;
            currentValue = params.get(param.getName());
            if (currentValue != null) {
                ArrayList<Object> values = null;
                if (currentValue instanceof List) {
                    values = (ArrayList<Object>)currentValue;
                } else {
                    values = new ArrayList<Object>();
                    values.add(currentValue);
                    params.put(param.getName(), values);
                }
                if (param.getValue() == null) {
                    values.add(EMPTY_VALUE);
                    continue;
                }
                values.add(param.getValue());
                continue;
            }
            if (param.getValue() == null) {
                params.put(param.getName(), EMPTY_VALUE);
                continue;
            }
            params.put(param.getName(), param.getValue());
        }
    }

    public abstract E createEntry(String var1, String var2);

    public abstract Series<E> createSeries(List<E> var1);

    private boolean equals(String value1, String value2, boolean ignoreCase) {
        boolean result;
        boolean bl = result = value1 == value2;
        if (!result && value1 != null && value2 != null) {
            result = ignoreCase ? value1.equalsIgnoreCase(value2) : value1.equals(value2);
        }
        return result;
    }

    public E getFirst(String name) {
        return this.getFirst(name, false);
    }

    public E getFirst(String name, boolean ignoreCase) {
        for (Parameter param : this) {
            if (!this.equals(param.getName(), name, ignoreCase)) continue;
            return (E)param;
        }
        return null;
    }

    public String getFirstValue(String name) {
        return this.getFirstValue(name, false);
    }

    public String getFirstValue(String name, boolean ignoreCase) {
        return this.getFirstValue(name, ignoreCase, null);
    }

    public String getFirstValue(String name, boolean ignoreCase, String defaultValue) {
        String result = defaultValue;
        E param = this.getFirst(name, ignoreCase);
        if (param != null && ((Parameter)param).getValue() != null) {
            result = ((Parameter)param).getValue();
        }
        return result;
    }

    public String getFirstValue(String name, String defaultValue) {
        return this.getFirstValue(name, false, defaultValue);
    }

    public Set<String> getNames() {
        HashSet<String> result = new HashSet<String>();
        for (Parameter param : this) {
            result.add(param.getName());
        }
        return result;
    }

    public String getValues(String name) {
        return this.getValues(name, ",", true);
    }

    public String getValues(String name, String separator, boolean ignoreCase) {
        String result = null;
        StringBuilder sb = null;
        for (Parameter param : this) {
            if ((!ignoreCase || !param.getName().equalsIgnoreCase(name)) && !param.getName().equals(name)) continue;
            if (sb == null) {
                if (result == null) {
                    result = param.getValue();
                    continue;
                }
                sb = new StringBuilder();
                sb.append(result).append(separator).append(param.getValue());
                continue;
            }
            sb.append(separator).append(param.getValue());
        }
        if (sb != null) {
            result = sb.toString();
        }
        return result;
    }

    public String[] getValuesArray(String name) {
        return this.getValuesArray(name, false);
    }

    public String[] getValuesArray(String name, boolean ignoreCase) {
        return this.getValuesArray(name, ignoreCase, null);
    }

    public String[] getValuesArray(String name, boolean ignoreCase, String defaultValue) {
        String[] result = null;
        Series<E> params = this.subList(name, ignoreCase);
        if (params.size() == 0 && defaultValue != null) {
            result = new String[]{defaultValue};
        } else {
            result = new String[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                result[i] = ((Parameter)params.get(i)).getValue();
            }
        }
        return result;
    }

    public String[] getValuesArray(String name, String defaultValue) {
        return this.getValuesArray(name, false, defaultValue);
    }

    public Map<String, String> getValuesMap() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Parameter param : this) {
            if (result.containsKey(param.getName())) continue;
            result.put(param.getName(), param.getValue());
        }
        return result;
    }

    public boolean removeAll(String name) {
        return this.removeAll(name, false);
    }

    public boolean removeAll(String name, boolean ignoreCase) {
        boolean changed = false;
        Parameter param = null;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            param = (Parameter)iter.next();
            if (!this.equals(param.getName(), name, ignoreCase)) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    public boolean removeFirst(String name) {
        return this.removeFirst(name, false);
    }

    public boolean removeFirst(String name, boolean ignoreCase) {
        boolean changed = false;
        Parameter param = null;
        Iterator iter = this.iterator();
        while (iter.hasNext() && !changed) {
            param = (Parameter)iter.next();
            if (!this.equals(param.getName(), name, ignoreCase)) continue;
            iter.remove();
            changed = true;
        }
        return changed;
    }

    public E set(String name, String value) {
        return this.set(name, value, false);
    }

    public E set(String name, String value, boolean ignoreCase) {
        Parameter result = null;
        Parameter param = null;
        boolean found = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            param = (Parameter)iter.next();
            if (!this.equals(param.getName(), name, ignoreCase)) continue;
            if (found) {
                iter.remove();
                continue;
            }
            found = true;
            param.setValue(value);
            result = param;
        }
        if (!found) {
            this.add(name, value);
        }
        return (E)result;
    }

    @Override
    public Series<E> subList(int fromIndex, int toIndex) {
        return this.createSeries(this.getDelegate().subList(fromIndex, toIndex));
    }

    public Series<E> subList(String name) {
        return this.subList(name, false);
    }

    public Series<E> subList(String name, boolean ignoreCase) {
        Series<Parameter> result = this.createSeries(null);
        for (Parameter param : this) {
            if (!this.equals(param.getName(), name, ignoreCase)) continue;
            result.add(param);
        }
        return result;
    }
}

