/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.restlet.Context;
import org.restlet.data.Encoding;
import org.restlet.data.MediaType;
import org.restlet.engine.application.Encoder;
import org.restlet.representation.Representation;
import org.restlet.routing.Filter;
import org.restlet.service.Service;

public class EncoderService
extends Service {
    public static final int ANY_SIZE = -1;
    public static final int DEFAULT_MINIMUM_SIZE = 1000;
    private volatile List<MediaType> acceptedMediaTypes = EncoderService.getDefaultAcceptedMediaTypes();
    private volatile List<MediaType> ignoredMediaTypes = EncoderService.getDefaultIgnoredMediaTypes();
    private volatile long mininumSize = 1000L;

    public static List<MediaType> getDefaultAcceptedMediaTypes() {
        ArrayList<MediaType> result = new ArrayList<MediaType>();
        result.add(MediaType.ALL);
        return result;
    }

    public static List<MediaType> getDefaultIgnoredMediaTypes() {
        List<MediaType> result = Arrays.asList(MediaType.APPLICATION_CAB, MediaType.APPLICATION_GNU_ZIP, MediaType.APPLICATION_ZIP, MediaType.APPLICATION_GNU_TAR, MediaType.APPLICATION_JAVA_ARCHIVE, MediaType.APPLICATION_STUFFIT, MediaType.APPLICATION_TAR, MediaType.AUDIO_ALL, MediaType.IMAGE_ALL, MediaType.VIDEO_ALL);
        return result;
    }

    public EncoderService() {
        this(true);
    }

    public EncoderService(boolean enabled) {
        super(enabled);
    }

    public boolean canEncode(Representation representation) {
        Iterator<MediaType> iter;
        boolean result = false;
        if (representation != null) {
            boolean identity = true;
            Iterator<Encoding> iter2 = representation.getEncodings().iterator();
            while (identity && iter2.hasNext()) {
                identity = iter2.next().equals(Encoding.IDENTITY);
            }
            result = identity;
        }
        if (result) {
            boolean bl = result = this.getMinimumSize() == -1L || representation.getSize() == -1L || representation.getSize() >= this.getMinimumSize();
        }
        if (result) {
            MediaType mediaType = representation.getMediaType();
            boolean accepted = false;
            iter = this.getAcceptedMediaTypes().iterator();
            while (!accepted && iter.hasNext()) {
                accepted = iter.next().includes(mediaType);
            }
            result = accepted;
        }
        if (result) {
            MediaType mediaType = representation.getMediaType();
            boolean rejected = false;
            iter = this.getIgnoredMediaTypes().iterator();
            while (!rejected && iter.hasNext()) {
                rejected = iter.next().includes(mediaType);
            }
            result = !rejected;
        }
        return result;
    }

    @Override
    public Filter createInboundFilter(Context context) {
        return new Encoder(context, false, true, this);
    }

    @Override
    public Filter createOutboundFilter(Context context) {
        return new Encoder(context, true, false, this);
    }

    public List<MediaType> getAcceptedMediaTypes() {
        return this.acceptedMediaTypes;
    }

    public List<MediaType> getIgnoredMediaTypes() {
        return this.ignoredMediaTypes;
    }

    public long getMinimumSize() {
        return this.mininumSize;
    }

    public void setMinimumSize(long mininumSize) {
        this.mininumSize = mininumSize;
    }
}

