/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch05.sec2.sub3;

import java.io.IOException;
import org.restlet.data.Reference;
import org.restlet.ext.xml.SaxRepresentation;
import org.restlet.ext.xml.XmlWriter;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MailServerResource
extends ServerResource {
    protected Representation get() throws ResourceException {
        SaxRepresentation result = new SaxRepresentation(){

            public void write(XmlWriter writer) throws IOException {
                try {
                    writer.startDocument();
                    writer.startElement("mail");
                    writer.startElement("status");
                    writer.characters("received");
                    writer.endElement("status");
                    writer.startElement("subject");
                    writer.characters("Message to self");
                    writer.endElement("subject");
                    writer.startElement("content");
                    writer.characters("Doh!");
                    writer.endElement("content");
                    writer.startElement("accountRef");
                    writer.characters(new Reference(MailServerResource.this.getReference(), "..").getTargetRef().toString());
                    writer.endElement("accountRef");
                    writer.endElement("mail");
                    writer.endDocument();
                }
                catch (SAXException e) {
                    throw new IOException(e.getMessage());
                }
            }
        };
        return result;
    }

    protected Representation put(Representation representation) throws ResourceException {
        SaxRepresentation mailRep = new SaxRepresentation(representation);
        try {
            mailRep.parse((ContentHandler)new DefaultHandler(){

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if ("status".equals(localName)) {
                        System.out.print("Status: ");
                    } else if ("subject".equals(localName)) {
                        System.out.print("Subject: ");
                    } else if ("content".equals(localName)) {
                        System.out.print("Content: ");
                    } else if ("accountRef".equals(localName)) {
                        System.out.print("Account URI: ");
                    }
                }

                public void characters(char[] ch, int start, int length) throws SAXException {
                    System.out.print(new String(ch, start, length));
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    System.out.println();
                }
            });
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
        return null;
    }
}

