/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch05.sec2.sub5;

import java.io.IOException;
import org.restlet.data.Reference;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MailServerResource
extends ServerResource {
    protected Representation get() throws ResourceException {
        DomRepresentation result;
        try {
            result = new DomRepresentation();
            result.setIndenting(true);
            result.setNamespaceAware(true);
            Document doc = result.getDocument();
            Element mailElt = doc.createElementNS("http://www.rmep.org/namespaces/1.0", "mail");
            doc.appendChild(mailElt);
            Element statusElt = doc.createElement("status");
            statusElt.setTextContent("received");
            mailElt.appendChild(statusElt);
            Element subjectElt = doc.createElement("subject");
            subjectElt.setTextContent("Message to self");
            mailElt.appendChild(subjectElt);
            Element contentElt = doc.createElement("content");
            contentElt.setTextContent("Doh!");
            mailElt.appendChild(contentElt);
            Element accountRefElt = doc.createElement("accountRef");
            accountRefElt.setTextContent(new Reference(this.getReference(), "..").getTargetRef().toString());
            mailElt.appendChild(accountRefElt);
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
        return result;
    }

    protected Representation put(Representation representation) throws ResourceException {
        DomRepresentation mailRep = new DomRepresentation(representation);
        String rmepNs = "http://www.rmep.org/namespaces/1.0";
        mailRep.setNamespaceAware(true);
        mailRep.getNamespaces().put("", rmepNs);
        mailRep.getNamespaces().put("rmep", rmepNs);
        String status = mailRep.getText("/:mail/:status");
        String subject = mailRep.getText("/rmep:mail/:subject");
        String content = mailRep.getText("/rmep:mail/rmep:content");
        String accountRef = mailRep.getText("/:mail/rmep:accountRef");
        System.out.println("Status: " + status);
        System.out.println("Subject: " + subject);
        System.out.println("Content: " + content);
        System.out.println("Account URI: " + accountRef);
        return null;
    }
}

