/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch05.sec2.sub7;

import java.io.IOException;
import org.restlet.data.LocalReference;
import org.restlet.data.Reference;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.ext.xml.TransformRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MailServerResource
extends ServerResource {
    protected Representation get() throws ResourceException {
        TransformRepresentation result = null;
        try {
            DomRepresentation rmepMail = new DomRepresentation();
            rmepMail.setIndenting(true);
            Document doc = rmepMail.getDocument();
            Element mailElt = doc.createElement("mail");
            doc.appendChild(mailElt);
            Element statusElt = doc.createElement("status");
            statusElt.setTextContent("received");
            mailElt.appendChild(statusElt);
            Element subjectElt = doc.createElement("subject");
            subjectElt.setTextContent("Message to self");
            mailElt.appendChild(subjectElt);
            Element contentElt = doc.createElement("content");
            contentElt.setTextContent("Doh!");
            mailElt.appendChild(contentElt);
            Element accountRefElt = doc.createElement("accountRef");
            accountRefElt.setTextContent(new Reference(this.getReference(), "..").getTargetRef().toString());
            mailElt.appendChild(accountRefElt);
            Representation transformSheet = new ClientResource(LocalReference.createClapReference((Package)((Object)((Object)this)).getClass().getPackage()) + "/Mail.xslt").get();
            result = new TransformRepresentation((Representation)rmepMail, transformSheet);
            result.getOutputProperties().put("indent", "yes");
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
        return result;
    }

    protected Representation put(Representation representation) throws ResourceException {
        DomRepresentation mailRep = new DomRepresentation(representation);
        String subject = mailRep.getText("/email/head/subject");
        String content = mailRep.getText("/email/body");
        System.out.println("Subject: " + subject);
        System.out.println("Content: " + content);
        return null;
    }
}

