/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch07.sec2.server;

import org.restlet.example.book.restlet.ch03.sect5.sub5.common.AccountResource;
import org.restlet.example.book.restlet.ch07.sec2.server.AccountsServerResource;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.ext.wadl.WadlServerResource;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountServerResource
extends WadlServerResource
implements AccountResource {
    private int accountId;

    protected RepresentationInfo describe(MethodInfo methodInfo, Class<?> representationClass, Variant variant) {
        RepresentationInfo result = new RepresentationInfo(variant);
        result.setReference("account");
        return result;
    }

    protected void doInit() throws ResourceException {
        String accountIdAttribute = (String)this.getRequestAttributes().get("accountId");
        if (accountIdAttribute != null) {
            this.accountId = Integer.parseInt(accountIdAttribute);
            this.setName("Resource for mail account \"" + this.accountId + "\"");
            this.setDescription("The resource describing the mail account number \"" + this.accountId + "\"");
        } else {
            this.setName("Mail account resource");
            this.setDescription("The resource describing a mail account");
        }
    }

    @Override
    public void remove() {
        AccountsServerResource.getAccounts().remove(this.accountId - 1);
    }

    @Override
    public String represent() {
        return AccountsServerResource.getAccounts().get(this.accountId - 1);
    }

    @Override
    public void store(String account) {
        AccountsServerResource.getAccounts().set(this.accountId - 1, account);
    }
}

