/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.jaxrs;

import java.security.Principal;
import javax.ws.rs.core.Application;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Protocol;
import org.restlet.example.ext.jaxrs.ExampleApplication;
import org.restlet.ext.jaxrs.JaxRsApplication;
import org.restlet.ext.jaxrs.RoleChecker;
import org.restlet.security.Authenticator;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.MemoryRealm;
import org.restlet.security.User;

public class GuardedExample {
    public static void main(String[] args) throws Exception {
        Component comp = new Component();
        Server server = comp.getServers().add(Protocol.HTTP, 80);
        JaxRsApplication application = new JaxRsApplication(comp.getContext().createChildContext());
        ChallengeAuthenticator guard = new ChallengeAuthenticator(application.getContext(), ChallengeScheme.HTTP_BASIC, "JAX-RS example");
        MemoryRealm realm = new MemoryRealm();
        application.getContext().setDefaultEnroler(realm.getEnroler());
        application.getContext().setDefaultVerifier(realm.getVerifier());
        realm.getUsers().add(new User("admin", "adminPW".toCharArray()));
        realm.getUsers().add(new User("alice", "alicesSecret".toCharArray()));
        realm.getUsers().add(new User("bob", "bobsSecret".toCharArray()));
        ExampleRoleChecker roleChecker = new ExampleRoleChecker();
        application.setAuthentication((Authenticator)guard, (RoleChecker)roleChecker);
        application.add((Application)new ExampleApplication());
        comp.getDefaultHost().attach((Restlet)application);
        comp.start();
        System.out.println("Server started on port " + server.getPort());
        System.out.println("Press key to stop server");
        System.in.read();
        System.out.println("Stopping server");
        comp.stop();
        System.out.println("Server stopped");
    }

    private static final class ExampleRoleChecker
    implements RoleChecker {
        private ExampleRoleChecker() {
        }

        public boolean isInRole(Principal principal, String role) {
            if (principal.getName().equalsIgnoreCase("admin")) {
                return true;
            }
            return role.equalsIgnoreCase("read");
        }
    }
}

