/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.rdf.foaf.resources;

import freemarker.template.Configuration;
import java.util.Map;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.example.ext.rdf.foaf.Application;
import org.restlet.example.ext.rdf.foaf.objects.Contact;
import org.restlet.example.ext.rdf.foaf.objects.ObjectsFacade;
import org.restlet.example.ext.rdf.foaf.objects.User;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.Literal;
import org.restlet.ext.rdf.RdfRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ServerResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseResource
extends ServerResource {
    static final String RDF_SYNTAX_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static final String FOAF_NS = "http://xmlns.com/foaf/0.1/";

    protected Representation getFoafRepresentation(User user, Reference userRef) {
        Graph graph = new Graph();
        this.addFoaf(graph, user, userRef);
        return new RdfRepresentation(graph, MediaType.TEXT_XML);
    }

    protected Representation getFoafRepresentation(Contact contact, Reference contactRef) {
        Graph graph = new Graph();
        this.addFoaf(graph, contact, contactRef);
        return new RdfRepresentation(graph, MediaType.TEXT_XML);
    }

    private void addFoaf(Graph graph, Contact contact, Reference contactRef) {
        this.addFoaf(graph, (User)contact, contactRef);
        this.addFoafProperty(graph, contactRef, "nickname", contact.getNickname());
    }

    private void addFoaf(Graph graph, User user, Reference userRef) {
        this.addLink(graph, userRef, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://xmlns.com/foaf/0.1/Person");
        this.addFoafProperty(graph, userRef, "name", user.getFirstName() + " " + user.getLastName());
        this.addFoafProperty(graph, userRef, "givenname", user.getFirstName());
        this.addFoafProperty(graph, userRef, "firstName", user.getFirstName());
        this.addFoafProperty(graph, userRef, "family_name", user.getLastName());
        this.addFoafProperty(graph, userRef, "img", user.getImage());
        this.addLink(graph, userRef, "http://xmlns.com/foaf/0.1/homepage", userRef);
        for (Contact contact : user.getContacts()) {
            Reference contactRef = null;
            contactRef = contact.getFoafUri() != null ? new Reference(contact.getFoafUri()) : new Reference(userRef + "/contacts/" + contact.getId());
            this.addLink(graph, userRef, "http://xmlns.com/foaf/0.1/knows", contactRef);
            this.addFoaf(graph, contact, contactRef);
        }
    }

    private void addFoafProperty(Graph graph, Reference subject, String predicate, String object) {
        graph.add(subject, new Reference(FOAF_NS + predicate), new Literal(object));
    }

    private void addLink(Graph graph, Reference subject, String predicate, Reference object) {
        graph.add(subject, new Reference(predicate), object);
    }

    private void addLink(Graph graph, Reference subject, String predicate, String object) {
        graph.add(subject, new Reference(predicate), new Reference(object));
    }

    protected Reference getChildReference(Reference parentRef, String childId) {
        if (parentRef.getIdentifier().endsWith("/")) {
            return new Reference(parentRef.getIdentifier() + childId);
        }
        return new Reference(parentRef.getIdentifier() + "/" + childId);
    }

    private Configuration getFmcConfiguration() {
        Application application = (Application)this.getApplication();
        return application.getFmc();
    }

    protected ObjectsFacade getObjectsFacade() {
        Application application = (Application)this.getApplication();
        return application.getObjectsFacade();
    }

    protected Representation getTemplateRepresentation(String templateName, Map<String, Object> dataModel, MediaType mediaType) {
        return new TemplateRepresentation(templateName, this.getFmcConfiguration(), dataModel, mediaType);
    }
}

