/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.firstResource;

import java.io.IOException;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.example.firstResource.BaseResource;
import org.restlet.example.firstResource.Item;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ItemsResource
extends BaseResource {
    @Post
    public Representation acceptItem(Representation entity) {
        Representation result = null;
        Form form = new Form(entity);
        String itemName = form.getFirstValue("name");
        String itemDescription = form.getFirstValue("description");
        if (!this.getItems().containsKey(itemName) && this.getItems().putIfAbsent(itemName, new Item(itemName, itemDescription)) == null) {
            this.setStatus(Status.SUCCESS_CREATED);
            StringRepresentation rep = new StringRepresentation((CharSequence)"Item created", MediaType.TEXT_PLAIN);
            rep.setLocationRef(this.getRequest().getResourceRef().getIdentifier() + "/" + itemName);
            result = rep;
        } else {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            result = this.generateErrorRepresentation("Item " + itemName + " already exists.", "1");
        }
        return result;
    }

    private Representation generateErrorRepresentation(String errorMessage, String errorCode) {
        DomRepresentation result = null;
        try {
            result = new DomRepresentation(MediaType.TEXT_XML);
            Document d = result.getDocument();
            Element eltError = d.createElement("error");
            Element eltCode = d.createElement("code");
            eltCode.appendChild(d.createTextNode(errorCode));
            eltError.appendChild(eltCode);
            Element eltMessage = d.createElement("message");
            eltMessage.appendChild(d.createTextNode(errorMessage));
            eltError.appendChild(eltMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Get(value="xml")
    public Representation toXml() {
        try {
            DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
            Document d = representation.getDocument();
            Element r = d.createElement("items");
            d.appendChild(r);
            for (Item item : this.getItems().values()) {
                Element eltItem = d.createElement("item");
                Element eltName = d.createElement("name");
                eltName.appendChild(d.createTextNode(item.getName()));
                eltItem.appendChild(eltName);
                Element eltDescription = d.createElement("description");
                eltDescription.appendChild(d.createTextNode(item.getDescription()));
                eltItem.appendChild(eltDescription);
                r.appendChild(eltItem);
            }
            d.normalizeDocument();
            return representation;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

