/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.tutorial;

import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.Directory;
import org.restlet.routing.Router;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.MapVerifier;
import org.restlet.security.Verifier;

public class Part11
extends Application {
    public static void main(String[] args) throws Exception {
        Component component = new Component();
        component.getServers().add(Protocol.HTTP, 8182);
        component.getClients().add(Protocol.FILE);
        Part11 application = new Part11();
        component.getDefaultHost().attach((Restlet)application);
        component.start();
    }

    public Restlet createInboundRoot() {
        Router router = new Router(this.getContext());
        MapVerifier verifier = new MapVerifier();
        verifier.getLocalSecrets().put("scott", "tiger".toCharArray());
        ChallengeAuthenticator guard = new ChallengeAuthenticator(this.getContext(), ChallengeScheme.HTTP_BASIC, "Tutorial");
        guard.setVerifier((Verifier)verifier);
        router.attach("/docs/", (Restlet)guard).setMatchingMode(1);
        Directory directory = new Directory(this.getContext(), "file:///c:/");
        guard.setNext((Restlet)directory);
        Restlet account = new Restlet(){

            public void handle(Request request, Response response) {
                String message = "Account of user \"" + request.getAttributes().get("user") + "\"";
                response.setEntity(message, MediaType.TEXT_PLAIN);
            }
        };
        Restlet orders = new Restlet(this.getContext()){

            public void handle(Request request, Response response) {
                String message = "Orders of user \"" + request.getAttributes().get("user") + "\"";
                response.setEntity(message, MediaType.TEXT_PLAIN);
            }
        };
        Restlet order = new Restlet(this.getContext()){

            public void handle(Request request, Response response) {
                String message = "Order \"" + request.getAttributes().get("order") + "\" for user \"" + request.getAttributes().get("user") + "\"";
                response.setEntity(message, MediaType.TEXT_PLAIN);
            }
        };
        router.attach("/users/{user}", account);
        router.attach("/users/{user}/orders", orders);
        router.attach("/users/{user}/orders/{order}", order);
        return router;
    }
}

