/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxb.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.restlet.Context;
import org.restlet.ext.jaxb.JaxbRepresentation;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unmarshaller<T> {
    private final String contextPath;
    private final ThreadLocal<javax.xml.bind.Unmarshaller> unmarshaller = new ThreadLocal<javax.xml.bind.Unmarshaller>(){

        @Override
        protected synchronized javax.xml.bind.Unmarshaller initialValue() {
            javax.xml.bind.Unmarshaller m = null;
            try {
                m = JaxbRepresentation.getContext(Unmarshaller.this.getContextPath(), Unmarshaller.this.getClassLoader()).createUnmarshaller();
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Problem creating Unmarshaller", e);
                return null;
            }
            return m;
        }
    };
    private final ClassLoader classLoader;

    public Unmarshaller(String contextPath, ClassLoader classloader) {
        this.contextPath = contextPath;
        this.classLoader = classloader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    private javax.xml.bind.Unmarshaller getUnmarshaller() throws JAXBException {
        javax.xml.bind.Unmarshaller m = this.unmarshaller.get();
        if (m == null) {
            Context.getCurrentLogger().warning("Unable to locate unmarshaller.");
            throw new JAXBException("Unable to locate unmarshaller.");
        }
        return m;
    }

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        this.getUnmarshaller().setEventHandler(handler);
    }

    public Object unmarshal(JaxbRepresentation<?> jaxbRep, InputStream stream) throws JAXBException {
        return this.unmarshal(jaxbRep, new InputStreamReader(stream));
    }

    public Object unmarshal(JaxbRepresentation<?> jaxbRep, Reader reader) throws JAXBException {
        SAXSource ss = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(jaxbRep.isValidatingDtd());
            spf.setXIncludeAware(jaxbRep.isXIncludeAware());
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", jaxbRep.isSecureProcessing());
            spf.setFeature("http://xml.org/sax/features/external-general-entities", jaxbRep.isExpandingEntityRefs());
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", jaxbRep.isExpandingEntityRefs());
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            ss = new SAXSource(xmlReader, new InputSource(reader));
        }
        catch (Exception e) {
            throw new JAXBException("Unable to create customized SAX source", (Throwable)e);
        }
        this.getUnmarshaller().setEventHandler(jaxbRep.getValidationEventHandler());
        return this.getUnmarshaller().unmarshal((Source)ss);
    }

    public Object unmarshal(JaxbRepresentation<?> jaxbRep) throws JAXBException, IOException {
        return this.unmarshal(jaxbRep, jaxbRep.getReader());
    }
}

