/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Path;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathOnClassException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathOnMethodException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingAnnotationException;
import org.restlet.ext.jaxrs.internal.util.EncodeOrCheck;
import org.restlet.ext.jaxrs.internal.util.MatchingResult;
import org.restlet.ext.jaxrs.internal.util.RemainingPath;
import org.restlet.ext.jaxrs.internal.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathRegExp {
    private static final String DEFAULT_REG_EXP = "[^/]+?";
    public static final PathRegExp EMPTY;
    private static final byte NAME_READ = 2;
    private static final byte NAME_READ_READY = 3;
    private static final byte NAME_READ_START = 1;
    private static final byte REGEXP_READ = 12;
    private static final byte REGEXP_READ_READY = 13;
    private static final byte REGEXP_READ_START = 11;
    private final boolean emptyOrSlash;
    private final Integer noLitChars;
    private int noNonDefaultRegExp = 0;
    private final int noOfCapturingGroups;
    private final String pathTemplateDec;
    private final String pathTemplateEnc;
    private final Pattern pattern;
    private final List<String> varNames = new ArrayList<String>();

    public static PathRegExp createForClass(Class<?> rrc) throws MissingAnnotationException, IllegalPathOnClassException, IllegalArgumentException {
        Path path = Util.getPathAnnotation(rrc);
        try {
            return new PathRegExp(path.value(), path);
        }
        catch (IllegalPathException ipe) {
            throw new IllegalPathOnClassException(ipe);
        }
    }

    public static PathRegExp createForMethod(Method annotatedMethod) throws IllegalPathOnMethodException, IllegalArgumentException {
        Path pathAnno = Util.getPathAnnotationOrNull(annotatedMethod);
        if (pathAnno == null) {
            return EMPTY;
        }
        try {
            return new PathRegExp(pathAnno.value(), pathAnno);
        }
        catch (IllegalPathException ipe) {
            throw new IllegalPathOnMethodException(ipe);
        }
    }

    private PathRegExp(String pathTemplate, Path pathForExcMess) throws IllegalPathException {
        if (pathTemplate == null) {
            throw new IllegalArgumentException("The path template must not be null");
        }
        int l = pathTemplate.length();
        StringBuilder pathPattern = new StringBuilder();
        int forStart = 0;
        if (l > 0 && pathTemplate.charAt(0) == '/') {
            forStart = 1;
        }
        int noLitChars = 0;
        int numberOfCapturingGroups = 0;
        for (int i = forStart; i < l; ++i) {
            char c = pathTemplate.charAt(i);
            if (c == '{') {
                i = this.processTemplVarname(pathTemplate, i, pathPattern, pathForExcMess);
                ++numberOfCapturingGroups;
                continue;
            }
            if (c == '%') {
                try {
                    EncodeOrCheck.processPercent(i, true, pathTemplate, pathPattern);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalPathException(pathForExcMess, e);
                }
            }
            if (c == '}') {
                throw new IllegalPathException(pathForExcMess, "'}' is only allowed as end of a variable name in \"" + pathTemplate + "\"");
            }
            if (c == ';') {
                throw new IllegalPathException(pathForExcMess, "matrix parameters are not allowed in a @Path");
            }
            if (c == '/') {
                pathPattern.append(c);
                ++noLitChars;
                continue;
            }
            noLitChars += EncodeOrCheck.encode(c, pathPattern);
        }
        this.noLitChars = noLitChars;
        this.noOfCapturingGroups = numberOfCapturingGroups;
        if (pathPattern.length() > 0 && pathPattern.charAt(pathPattern.length() - 1) != '/') {
            pathPattern.append('/');
        }
        pathPattern.append("(.*)");
        this.pattern = Pattern.compile(pathPattern.toString());
        this.emptyOrSlash = Util.isEmptyOrSlash(pathTemplate);
        if (l > 0) {
            if (pathTemplate.charAt(0) != '/') {
                pathTemplate = '/' + pathTemplate;
            }
            if (l > 1 && pathTemplate.endsWith("/")) {
                pathTemplate = pathTemplate.substring(0, pathTemplate.length() - 2);
            }
        }
        this.pathTemplateEnc = pathTemplate;
        this.pathTemplateDec = pathTemplate;
    }

    public boolean equals(Object anotherObject) {
        if (this == anotherObject) {
            return true;
        }
        if (!(anotherObject instanceof PathRegExp)) {
            return false;
        }
        PathRegExp otherRegExp = (PathRegExp)anotherObject;
        return this.pattern.pattern().equals(otherRegExp.pattern.pattern());
    }

    public int getNoNonDefCaprGroups() {
        return this.noNonDefaultRegExp;
    }

    public int getNoOfCapturingGroups() {
        return this.noOfCapturingGroups;
    }

    public int getNoOfLiteralChars() {
        return this.noLitChars;
    }

    public String getPathTemplateDec() {
        return this.pathTemplateDec;
    }

    public String getPathTemplateEnc() {
        return this.pathTemplateEnc;
    }

    public int hashCode() {
        return this.pattern.pattern().hashCode();
    }

    public boolean isEmptyOrSlash() {
        return this.emptyOrSlash;
    }

    public MatchingResult match(RemainingPath remainingPath) {
        String givenPath = remainingPath.getWithoutParams();
        Matcher matcher = this.pattern.matcher(givenPath);
        if (!matcher.matches()) {
            return null;
        }
        HashMap<String, String> templateVars = new HashMap<String, String>();
        for (int i = 1; i < matcher.groupCount(); ++i) {
            templateVars.put(this.varNames.get(i - 1), matcher.group(i));
        }
        String finalCapturingGroup = matcher.group(matcher.groupCount());
        int matchedChars = givenPath.length() - finalCapturingGroup.length();
        if (matchedChars > 0 && givenPath.charAt(matchedChars - 1) == '/') {
            --matchedChars;
        }
        String matchedPart = givenPath.substring(0, matchedChars);
        return new MatchingResult(matchedPart, templateVars, finalCapturingGroup);
    }

    public boolean matchesWithEmpty(RemainingPath remainingPath) {
        MatchingResult matchingResult = this.match(remainingPath);
        if (matchingResult == null) {
            return false;
        }
        return matchingResult.getFinalCapturingGroup().isEmptyOrSlash();
    }

    private int processTemplVarname(String pathTemplate, int braceIndex, StringBuilder pathPattern, Path pathForExcMess) throws IllegalPathException {
        pathPattern.append('(');
        int l = pathTemplate.length();
        StringBuilder varName = new StringBuilder();
        StringBuilder regExp = new StringBuilder();
        int state = 1;
        for (int i = braceIndex + 1; i < l; ++i) {
            char c = pathTemplate.charAt(i);
            if (c == '{') {
                throw new IllegalPathException(pathForExcMess, "A variable must not contain an extra '{' in \"" + pathTemplate + "\"");
            }
            if (c == ' ' || c == '\t') {
                if (state == 2) {
                    state = 3;
                    continue;
                }
                if (state != 12) continue;
                state = 13;
                continue;
            }
            if (c == ':') {
                if (state == 1) {
                    throw new IllegalPathException(pathForExcMess, "The variable name at position must not be null at " + braceIndex + " of \"" + pathTemplate + "\"");
                }
                if (state != 2 && state != 3) continue;
                state = 11;
                continue;
            }
            if (c == '}') {
                if (state == 1) {
                    throw new IllegalPathException(pathForExcMess, "The template variable name '{}' is not allowed in \"" + pathTemplate + "\"");
                }
                if (state == 12 || state == 13) {
                    pathPattern.append((CharSequence)regExp);
                    if (!regExp.equals(DEFAULT_REG_EXP)) {
                        ++this.noNonDefaultRegExp;
                    }
                } else {
                    pathPattern.append(DEFAULT_REG_EXP);
                }
                pathPattern.append(')');
                this.varNames.add(varName.toString());
                return i;
            }
            if (state == 1) {
                state = 2;
                varName.append(c);
                continue;
            }
            if (state == 2) {
                varName.append(c);
                continue;
            }
            if (state == 11) {
                state = 12;
                regExp.append(c);
                continue;
            }
            if (state == 12) {
                regExp.append(c);
                continue;
            }
            throw new IllegalPathException(pathForExcMess, "Invalid character found at position " + i + " of \"" + pathTemplate + "\"");
        }
        throw new IllegalPathException(pathForExcMess, "No '}' found after '{' at position " + braceIndex + " of \"" + pathTemplate + "\"");
    }

    public String toString() {
        return this.pattern.pattern();
    }

    static {
        try {
            EMPTY = new PathRegExp("", null);
        }
        catch (IllegalPathException e) {
            throw new RuntimeException("This could not occur", e);
        }
    }
}

