/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.ws.rs.Encoded;
import javax.ws.rs.WebApplicationException;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertRepresentationException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalMethodParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathOnMethodException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingAnnotationException;
import org.restlet.ext.jaxrs.internal.util.PathRegExp;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.ext.jaxrs.internal.wrappers.AbstractJaxRsWrapper;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceClass;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceObject;
import org.restlet.ext.jaxrs.internal.wrappers.params.ParameterList;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ExtensionBackwardMapping;
import org.restlet.ext.jaxrs.internal.wrappers.provider.JaxRsProviders;

public abstract class AbstractMethodWrapper
extends AbstractJaxRsWrapper {
    final Method executeMethod;
    final ParameterList parameters;
    final ResourceClass resourceClass;

    AbstractMethodWrapper(Method executeMethod, Method annotatedMethod, ResourceClass resourceClass, ThreadLocalizedContext tlContext, JaxRsProviders jaxRsProviders, ExtensionBackwardMapping extensionBackwardMapping, boolean entityAllowed, Logger logger) throws IllegalPathOnMethodException, IllegalArgumentException, MissingAnnotationException, IllegalMethodParamTypeException, IllegalPathParamTypeException {
        super(PathRegExp.createForMethod(annotatedMethod));
        this.executeMethod = executeMethod;
        this.executeMethod.setAccessible(true);
        this.resourceClass = resourceClass;
        boolean leaveEncoded = resourceClass.isLeaveEncoded() || annotatedMethod.isAnnotationPresent(Encoded.class);
        try {
            this.parameters = new ParameterList(executeMethod, annotatedMethod, tlContext, leaveEncoded, jaxRsProviders, extensionBackwardMapping, entityAllowed, logger);
        }
        catch (IllegalTypeException e) {
            throw new IllegalMethodParamTypeException(e);
        }
    }

    public String getName() {
        Object[] paramTypes = this.executeMethod.getParameterTypes();
        StringBuilder stb = new StringBuilder();
        stb.append(this.executeMethod.getName());
        stb.append('(');
        Util.append(stb, paramTypes);
        stb.append(')');
        return stb.toString();
    }

    public PathRegExp getPathRegExp() {
        return super.getPathRegExp();
    }

    public ResourceClass getResourceClass() {
        return this.resourceClass;
    }

    Object internalInvoke(ResourceObject resourceObject) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ConvertRepresentationException, WebApplicationException {
        Object[] args = this.parameters.get();
        Object jaxRsResourceObj = resourceObject.getJaxRsResourceObject();
        return this.executeMethod.invoke(jaxRsResourceObj, args);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.executeMethod.getDeclaringClass().getSimpleName() + "." + this.executeMethod.getName() + "(__)]";
    }
}

