/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers.params;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import org.restlet.Request;
import org.restlet.data.MediaType;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertRepresentationException;
import org.restlet.ext.jaxrs.internal.exceptions.NoMessageBodyReaderException;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.ext.jaxrs.internal.wrappers.params.ParameterList;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyReader;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyReaderSet;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityGetter
implements ParameterList.ParamGetter {
    private final Annotation[] annotations;
    protected volatile Class<?> convToCl;
    private final Type convToGen;
    private final MessageBodyReaderSet mbrs;
    protected final ThreadLocalizedContext tlContext;

    EntityGetter(Class<?> convToCl, Type convToGen, ThreadLocalizedContext tlContext, MessageBodyReaderSet mbrs, Annotation[] annotations) {
        this.tlContext = tlContext;
        this.mbrs = mbrs;
        this.convToCl = convToCl;
        this.convToGen = convToGen;
        this.annotations = annotations;
    }

    @Override
    public Object getValue() throws ConvertRepresentationException, InvocationTargetException {
        Request request = this.tlContext.get().getRequest();
        Representation entity = request.getEntity();
        if (entity == null) {
            return null;
        }
        MediaType mediaType = entity.getMediaType();
        MessageBodyReader mbr = this.mbrs.getBestReader(this.convToCl, this.convToGen, this.annotations, mediaType);
        if (mbr == null) {
            throw new NoMessageBodyReaderException(mediaType, this.convToCl);
        }
        MultivaluedMap<String, String> httpHeaders = Util.getJaxRsHttpHeaders(request);
        try {
            Object object = mbr.readFrom(this.convToCl, this.convToGen, this.annotations, mediaType, entity.getCharacterSet(), httpHeaders, entity.getStream());
            return object;
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (IOException e) {
            throw ConvertRepresentationException.object(this.convToCl, "the message body", e);
        }
        finally {
            entity.release();
        }
    }
}

