/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.ResponseType;

public class AuthSession {
    private final ConcurrentMap<String, Object> attribs = new ConcurrentHashMap<String, Object>();
    private static final String ID = "id";
    private static final String CLIENT = "client";
    private static final String REQ_SCOPE = "requested_scope";
    private static final String FLOW = "flow";
    private static final String DYN_CALLBACK = "dynamic_callback";
    private static final String OWNER = "owner";
    private static final String STATE = "state";
    protected volatile ScheduledThreadPoolExecutor executor;
    protected volatile long timeoutMin = 3600L;

    public AuthSession(ConcurrentMap<String, Object> sessions, ScheduledThreadPoolExecutor executor) {
        String sessionId = UUID.randomUUID().toString();
        this.setAttribute(ID, sessionId);
        sessions.put(sessionId, this);
    }

    public String getId() {
        return (String)this.getAttribute(ID);
    }

    public void setClient(Client client) {
        this.setAttribute(CLIENT, client);
    }

    public Client getClient() {
        return (Client)this.getAttribute(CLIENT);
    }

    public void setRequestedScope(String[] scope) {
        this.setAttribute(REQ_SCOPE, scope);
    }

    public String[] getRequestedScope() {
        return (String[])this.getAttribute(REQ_SCOPE);
    }

    public void setScopeOwner(String owner) {
        this.setAttribute(OWNER, owner);
    }

    public String getScopeOwner() {
        return (String)this.getAttribute(OWNER);
    }

    public void setAuthFlow(ResponseType flow) {
        this.setAttribute(FLOW, (Object)flow);
    }

    public ResponseType getAuthFlow() {
        return (ResponseType)((Object)this.getAttribute(FLOW));
    }

    public void setState(String state) {
        this.setAttribute(STATE, state);
    }

    public String getState() {
        return (String)this.getAttribute(STATE);
    }

    public void setDynamicCallbackURI(String uri) {
        this.setAttribute(DYN_CALLBACK, uri);
    }

    public String getDynamicCallbackURI() {
        return (String)this.getAttribute(DYN_CALLBACK);
    }

    public void reset() {
        this.removeAttribute(CLIENT);
        this.removeAttribute(REQ_SCOPE);
        this.removeAttribute(FLOW);
        this.removeAttribute(DYN_CALLBACK);
    }

    public void setThreadPoolExecutor(ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public ScheduledThreadPoolExecutor getThreadPoolExecutor() {
        return this.executor;
    }

    public void setSessionTimeout(long timeMinutes) {
        this.timeoutMin = timeMinutes;
    }

    public long getSessionTimeout() {
        return this.timeoutMin;
    }

    private Object getAttribute(String name) {
        this.handleActivity();
        return this.attribs.get(name);
    }

    private void setAttribute(String name, Object value) {
        this.handleActivity();
        if (value == null) {
            this.removeAttribute(name);
        } else {
            this.attribs.put(name, value);
        }
    }

    private Object removeAttribute(String name) {
        this.handleActivity();
        return this.attribs.remove(name);
    }

    private void handleActivity() {
    }
}

