/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sdc.internal;

import com.google.dataconnector.protocol.Dispatchable;
import com.google.dataconnector.protocol.FrameReceiver;
import com.google.dataconnector.protocol.FrameSender;
import com.google.dataconnector.protocol.FramingException;
import com.google.dataconnector.protocol.proto.SdcFrame;
import com.google.dataconnector.util.ShutdownManager;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocket;
import org.restlet.ext.sdc.SdcClientHelper;
import org.restlet.ext.sdc.internal.SdcClientCall;

public class SdcServerConnection
implements Dispatchable {
    private final Map<String, SdcClientCall> calls;
    private final FrameReceiver frameReceiver;
    private final FrameSender frameSender;
    private final SdcClientHelper helper;
    private final InputStream inputStream;
    private volatile String key;
    private final OutputStream outputStream;
    private final SSLSocket socket;

    public SdcServerConnection(SdcClientHelper helper, SSLSocket socket) throws IOException {
        this.helper = helper;
        this.socket = socket;
        this.inputStream = socket.getInputStream();
        this.outputStream = socket.getOutputStream();
        this.frameReceiver = new FrameReceiver();
        this.frameReceiver.setInputStream(this.getInputStream());
        this.calls = new ConcurrentHashMap<String, SdcClientCall>();
        LinkedBlockingQueue sendQueue = new LinkedBlockingQueue();
        ShutdownManager shutdownManager = new ShutdownManager();
        this.frameSender = new FrameSender(sendQueue, shutdownManager);
        this.frameSender.setOutputStream(this.getOutputStream());
    }

    public void connect() throws IOException {
        try {
            this.readHandshake();
            SdcFrame.FrameInfo frameInfo = this.getFrameReceiver().readOneFrame();
            if (frameInfo.getType() == SdcFrame.FrameInfo.Type.AUTHORIZATION) {
                SdcFrame.AuthorizationInfo authorizationRequest = SdcFrame.AuthorizationInfo.parseFrom((ByteString)frameInfo.getPayload());
                this.setKey(authorizationRequest.getEmail() + ":" + authorizationRequest.getPassword());
                SdcFrame.AuthorizationInfo authorizationResponse = SdcFrame.AuthorizationInfo.newBuilder().setResult(SdcFrame.AuthorizationInfo.ResultCode.OK).build();
                this.getFrameSender().sendFrame(SdcFrame.FrameInfo.Type.AUTHORIZATION, authorizationResponse.toByteString());
                this.getFrameReceiver().registerDispatcher(SdcFrame.FrameInfo.Type.FETCH_REQUEST, (Dispatchable)this);
                this.getFrameReceiver().registerDispatcher(SdcFrame.FrameInfo.Type.REGISTRATION, (Dispatchable)this);
                this.getFrameReceiver().registerDispatcher(SdcFrame.FrameInfo.Type.HEALTH_CHECK, (Dispatchable)this);
                this.getHelper().getWorkerService().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SdcServerConnection.this.getFrameReceiver().startDispatching();
                        }
                        catch (FramingException e) {
                            e.printStackTrace();
                        }
                    }
                });
                this.getHelper().getWorkerService().execute(new Runnable(){

                    @Override
                    public void run() {
                        SdcServerConnection.this.getFrameSender().run();
                    }
                });
            } else {
                System.out.println("Unable to authorize the connection. Wrong frame type received: " + frameInfo);
            }
        }
        catch (FramingException e) {
            e.printStackTrace();
        }
    }

    public void dispatch(SdcFrame.FrameInfo frameInfo) throws FramingException {
        try {
            if (frameInfo.getType() == SdcFrame.FrameInfo.Type.FETCH_REQUEST) {
                SdcClientCall call;
                SdcFrame.FetchReply fetchReply = SdcFrame.FetchReply.parseFrom((ByteString)frameInfo.getPayload());
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.FINE, "SDC response received: " + fetchReply.toString());
                }
                if ((call = this.getCalls().get(fetchReply.getId())) != null) {
                    call.setFetchReply(fetchReply);
                    call.getLatch().countDown();
                } else if (this.getLogger().isLoggable(Level.WARNING)) {
                    this.getLogger().log(Level.WARNING, "Unable to find the SDC request associated to the received response");
                }
            } else if (frameInfo.getType() == SdcFrame.FrameInfo.Type.REGISTRATION) {
                SdcFrame.RegistrationRequestV4 registrationRequest = SdcFrame.RegistrationRequestV4.parseFrom((ByteString)frameInfo.getPayload());
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.FINE, "SDC tunnel registration received: " + registrationRequest);
                }
                SdcFrame.RegistrationResponseV4 registrationResponse = SdcFrame.RegistrationResponseV4.newBuilder().setResult(SdcFrame.RegistrationResponseV4.ResultCode.OK).setServerSuppliedConf(SdcFrame.ServerSuppliedConf.newBuilder().setHealthCheckTimeout(5000).setHealthCheckWakeUpInterval(5000).build()).build();
                this.getFrameSender().sendFrame(SdcFrame.FrameInfo.Type.REGISTRATION, registrationResponse.toByteString());
            } else if (frameInfo.getType() == SdcFrame.FrameInfo.Type.HEALTH_CHECK) {
                SdcFrame.HealthCheckInfo healthCheckResponse = SdcFrame.HealthCheckInfo.newBuilder().setSource(SdcFrame.HealthCheckInfo.Source.SERVER).setTimeStamp(System.currentTimeMillis()).setType(SdcFrame.HealthCheckInfo.Type.RESPONSE).build();
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.FINE, "SDC health check received: " + healthCheckResponse);
                }
                this.getFrameSender().sendFrame(SdcFrame.FrameInfo.Type.HEALTH_CHECK, healthCheckResponse.toByteString());
            } else if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, "Unexpected SDC frame received: " + frameInfo);
            }
        }
        catch (InvalidProtocolBufferException e) {
            this.getLogger().log(Level.WARNING, "Invalid SDC frame received", e);
        }
    }

    public Map<String, SdcClientCall> getCalls() {
        return this.calls;
    }

    public FrameReceiver getFrameReceiver() {
        return this.frameReceiver;
    }

    public FrameSender getFrameSender() {
        return this.frameSender;
    }

    public SdcClientHelper getHelper() {
        return this.helper;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getKey() {
        return this.key;
    }

    public Logger getLogger() {
        return this.getHelper().getLogger();
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public SSLSocket getSocket() {
        return this.socket;
    }

    protected boolean readHandshake() throws IOException {
        boolean result = true;
        byte[] hsm = ("v5.0 " + FrameReceiver.class.getPackage().getImplementationVersion() + "\n").getBytes();
        for (int i = 0; result && i < hsm.length; ++i) {
            int c = this.getInputStream().read();
            result = c == hsm[i];
        }
        return result;
    }

    public void sendRequest(SdcClientCall call) {
        this.getCalls().put(call.getFetchRequest().getId(), call);
        this.getFrameSender().sendFrame(SdcFrame.FrameInfo.Type.FETCH_REQUEST, call.getFetchRequest().toByteString());
    }

    public void setKey(String key) {
        this.key = key;
    }
}

