/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip.internal;

import java.io.IOException;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.ext.sip.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressReader
extends HeaderReader<Address> {
    public AddressReader(String header) {
        super(header);
    }

    private String readReference() throws IOException {
        String result = null;
        int next = this.read();
        if (next == 60) {
            StringBuilder buffer = new StringBuilder();
            while (result == null) {
                next = this.read();
                if (next == 62) {
                    result = buffer.toString();
                    continue;
                }
                if (next == -1) {
                    throw new IOException("Unexpected end of reference. Please check your value");
                }
                buffer.append((char)next);
            }
        } else {
            throw new IOException("A reference must start with a '<' character");
        }
        return result;
    }

    public Address readValue() throws IOException {
        Address result = null;
        this.skipSpaces();
        if (this.peek() != -1) {
            result = new Address();
            if (this.peek() == 34) {
                result.setDisplayName(this.readQuotedString());
                this.skipSpaces();
                result.setReference(new Reference(this.readReference()));
            } else if (this.peek() == 60) {
                result.setReference(new Reference(this.readReference()));
            } else if (HeaderUtils.isTokenChar((int)this.peek())) {
                int index;
                StringBuilder sb = null;
                int next = this.read();
                while (next != -1 && !HeaderUtils.isComma((int)next) && !HeaderUtils.isSemiColon((int)next)) {
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append((char)next);
                    next = this.read();
                }
                if (sb != null) {
                    for (int i = sb.length() - 1; i >= 0 && HeaderUtils.isLinearWhiteSpace((int)sb.charAt(i)); --i) {
                        sb.deleteCharAt(i);
                    }
                }
                if (HeaderUtils.isComma((int)next) || HeaderUtils.isSemiColon((int)next)) {
                    this.unread();
                }
                if ((index = sb.lastIndexOf(" ")) != -1) {
                    if (sb.charAt(index + 1) == '<') {
                        if (sb.charAt(sb.length() - 1) == '>') {
                            result.setReference(new Reference(sb.substring(index + 2, sb.length() - 1)));
                        } else {
                            throw new IOException("Unexpected end of reference. Please check your value");
                        }
                    }
                    result.setDisplayName(sb.substring(0, index).trim());
                } else {
                    result.setReference(new Reference(sb.toString()));
                }
            }
        }
        if (this.skipParameterSeparator()) {
            Parameter param = this.readParameter();
            while (param != null) {
                result.getParameters().add((Object)param);
                if (this.skipParameterSeparator()) {
                    param = this.readParameter();
                    continue;
                }
                param = null;
            }
        }
        return result;
    }
}

