/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xdb.internal;

import java.io.IOException;
import java.io.OutputStream;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.util.StringUtils;

public class ChunkedOutputStream
extends OutputStream {
    private static final int DEFAULT_CHUNK_SIZE = 2048;
    private final byte[] buffer;
    private volatile int bytesWritten;
    private volatile boolean closed;
    private final OutputStream destination;

    public ChunkedOutputStream(OutputStream destination) {
        this(destination, 2048);
    }

    public ChunkedOutputStream(OutputStream destination, int chunkSize) {
        this.destination = destination;
        this.buffer = new byte[chunkSize];
        this.bytesWritten = 0;
        this.closed = false;
    }

    private boolean chunkFull() {
        return this.bytesWritten == this.buffer.length;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.writeChunk();
            this.writeFinalChunk();
            super.close();
            this.closed = true;
            this.destination.flush();
        }
    }

    public void flush() throws IOException {
        this.writeChunk();
        this.destination.flush();
    }

    private void reset() {
        this.bytesWritten = 0;
    }

    public void write(int b) throws IOException {
        if (this.chunkFull()) {
            this.writeChunk();
        }
        this.buffer[this.bytesWritten++] = (byte)b;
    }

    private void writeChunk() throws IOException {
        if (this.bytesWritten > 0) {
            this.destination.write(StringUtils.getAsciiBytes((String)Integer.toHexString(this.bytesWritten)));
            HeaderUtils.writeCRLF((OutputStream)this.destination);
            this.destination.write(this.buffer, 0, this.bytesWritten);
            HeaderUtils.writeCRLF((OutputStream)this.destination);
            this.reset();
        }
    }

    private void writeFinalChunk() throws IOException {
        this.destination.write(48);
        HeaderUtils.writeCRLF((OutputStream)this.destination);
        HeaderUtils.writeCRLF((OutputStream)this.destination);
    }
}

