/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xdb.internal;

import java.io.IOException;
import java.io.InputStream;
import org.restlet.ext.xdb.internal.InputEntityStream;
import org.restlet.ext.xdb.internal.Notifiable;

public class SizedInputStream
extends InputEntityStream {
    private volatile long availableSize;
    private volatile long markedAvailableSize;

    public SizedInputStream(Notifiable notifiable, InputStream inboundStream, long size) {
        super(notifiable, inboundStream);
        this.availableSize = size;
        this.markedAvailableSize = -1L;
    }

    public int available() throws IOException {
        return Math.min((int)this.availableSize, this.getInboundStream().available());
    }

    public void close() throws IOException {
    }

    public synchronized void mark(int readlimit) {
        if (this.markSupported()) {
            this.markedAvailableSize = this.availableSize;
        }
        this.getInboundStream().mark(readlimit);
    }

    public boolean markSupported() {
        return this.getInboundStream().markSupported();
    }

    public int read() throws IOException {
        int result = -1;
        if (this.availableSize > 0L) {
            result = this.getInboundStream().read();
            if (result != -1) {
                --this.availableSize;
            } else {
                this.onEndReached();
            }
        }
        if (this.availableSize <= 0L) {
            this.onEndReached();
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = -1;
        if (this.availableSize > 0L) {
            result = this.getInboundStream().read(b, off, Math.min(len, (int)this.availableSize));
            if (result > 0) {
                this.availableSize -= (long)result;
            } else if (result == -1) {
                this.onEndReached();
            }
        }
        if (this.availableSize <= 0L) {
            this.onEndReached();
        }
        return result;
    }

    public synchronized void reset() throws IOException {
        if (this.markSupported() && this.markedAvailableSize != -1L) {
            this.availableSize = this.markedAvailableSize;
            this.markedAvailableSize = -1L;
        }
        this.getInboundStream().reset();
    }

    public long skip(long n) throws IOException {
        return this.getInboundStream().skip(n);
    }
}

