/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xdb.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.engine.header.Header;
import org.restlet.ext.xdb.internal.ChunkedInputStream;
import org.restlet.ext.xdb.internal.ChunkedOutputStream;
import org.restlet.ext.xdb.internal.SizedInputStream;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XdbServletCall
extends ServerCall {
    private volatile HttpServletRequest request;
    private volatile InputStream requestEntityStream;
    private volatile Series<Header> requestHeaders;
    private volatile HttpServletResponse response;
    private volatile OutputStream responseEntityStream;

    public XdbServletCall(Server server, HttpServletRequest request, HttpServletResponse response) {
        super(server);
        this.request = request;
        this.response = response;
    }

    public XdbServletCall(String serverAddress, int serverPort, HttpServletRequest request, HttpServletResponse response) {
        super(serverAddress, serverPort);
        this.request = request;
        this.response = response;
    }

    public boolean abort() {
        return false;
    }

    public List<Certificate> getCertificates() {
        Certificate[] certificateArray = (Certificate[])this.getRequest().getAttribute("javax.servlet.request.X509Certificate");
        if (certificateArray != null) {
            return Arrays.asList(certificateArray);
        }
        return Arrays.asList(new Certificate[0]);
    }

    public String getCipherSuite() {
        return (String)this.getRequest().getAttribute("javax.servlet.request.cipher_suite");
    }

    public String getMethod() {
        return this.getRequest().getMethod();
    }

    public Protocol getProtocol() {
        return Protocol.valueOf((String)this.getRequest().getScheme());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public InputStream getRequestEntityStream(long size) {
        if (this.requestEntityStream == null) {
            try {
                this.requestEntityStream = this.isRequestChunked() ? new ChunkedInputStream(null, (InputStream)this.getRequest().getInputStream()) : new SizedInputStream(null, (InputStream)this.getRequest().getInputStream(), size);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.requestEntityStream;
    }

    public Series<Header> getRequestHeaders() {
        if (this.requestHeaders == null) {
            this.requestHeaders = new Series(Header.class);
            Enumeration names = this.getRequest().getHeaderNames();
            while (names.hasMoreElements()) {
                String headerName = (String)names.nextElement();
                Enumeration values = this.getRequest().getHeaders(headerName);
                while (values.hasMoreElements()) {
                    String headerValue = (String)values.nextElement();
                    this.requestHeaders.add(headerName, headerValue);
                }
            }
        }
        return this.requestHeaders;
    }

    public InputStream getRequestHeadStream() {
        return null;
    }

    public String getRequestUri() {
        String queryString = this.getRequest().getQueryString();
        if (queryString == null || queryString.equals("")) {
            return this.getRequest().getRequestURI();
        }
        return this.getRequest().getRequestURI() + '?' + queryString;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public OutputStream getResponseEntityStream() {
        if (this.responseEntityStream == null) {
            try {
                this.responseEntityStream = this.isResponseChunked() ? new ChunkedOutputStream((OutputStream)this.getResponse().getOutputStream()) : this.getResponse().getOutputStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.responseEntityStream;
    }

    public Integer getSslKeySize() {
        Integer keySize = (Integer)this.getRequest().getAttribute("javax.servlet.request.key_size");
        if (keySize == null) {
            keySize = super.getSslKeySize();
        }
        return keySize;
    }

    public String getSslSessionId() {
        Object sessionId = this.getRequest().getAttribute("javax.servlet.request.ssl_session_id");
        if (sessionId != null && sessionId instanceof String) {
            return (String)sessionId;
        }
        sessionId = this.getRequest().getAttribute("javax.servlet.request.ssl_session");
        if (sessionId instanceof String) {
            return (String)sessionId;
        }
        return null;
    }

    public String getVersion() {
        String result = null;
        int index = this.getRequest().getProtocol().indexOf(47);
        if (index != -1) {
            result = this.getRequest().getProtocol().substring(index + 1);
        }
        return result;
    }

    public boolean isConfidential() {
        return this.getRequest().isSecure();
    }

    public void sendResponse(Response response) throws IOException {
        for (Header header : this.getResponseHeaders()) {
            this.getResponse().addHeader(header.getName(), header.getValue());
        }
        if (Status.isError((int)this.getStatusCode()) && response == null) {
            try {
                this.getResponse().sendError(this.getStatusCode(), this.getReasonPhrase());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to set the response error status", ioe);
            }
        } else {
            this.getResponse().setStatus(this.getStatusCode());
            super.sendResponse(response);
        }
    }
}

