/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XstreamRepresentation<T>
extends WriterRepresentation {
    private Class<? extends HierarchicalStreamDriver> jsonDriverClass;
    private T object;
    private Representation representation;
    private Class<? extends HierarchicalStreamDriver> xmlDriverClass;
    private XStream xstream;

    public XstreamRepresentation(MediaType mediaType, T object) {
        super(mediaType);
        this.object = object;
        this.representation = null;
        this.jsonDriverClass = JettisonMappedXmlDriver.class;
        this.xmlDriverClass = DomDriver.class;
        this.xstream = null;
    }

    public XstreamRepresentation(Representation representation) {
        super(representation.getMediaType());
        this.object = null;
        this.representation = representation;
        this.jsonDriverClass = JettisonMappedXmlDriver.class;
        this.xmlDriverClass = DomDriver.class;
        this.xstream = null;
    }

    public XstreamRepresentation(T object) {
        this(MediaType.APPLICATION_XML, object);
    }

    protected XStream createXstream(MediaType mediaType) {
        XStream result = null;
        try {
            if (MediaType.APPLICATION_JSON.isCompatible((Metadata)mediaType)) {
                result = new XStream(this.getJsonDriverClass().newInstance());
                result.setMode(1001);
            } else {
                result = new XStream(this.getXmlDriverClass().newInstance());
            }
            result.autodetectAnnotations(true);
        }
        catch (Exception e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to create the XStream driver.", e);
        }
        return result;
    }

    public Class<? extends HierarchicalStreamDriver> getJsonDriverClass() {
        return this.jsonDriverClass;
    }

    public T getObject() {
        Object result = null;
        if (this.object != null) {
            result = this.object;
        } else if (this.representation != null) {
            try {
                result = this.getXstream().fromXML(this.representation.getStream());
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the object with XStream.", e);
            }
        }
        return (T)result;
    }

    public Class<? extends HierarchicalStreamDriver> getXmlDriverClass() {
        return this.xmlDriverClass;
    }

    public XStream getXstream() {
        if (this.xstream == null) {
            this.xstream = this.createXstream(this.getMediaType());
        }
        return this.xstream;
    }

    public void setJsonDriverClass(Class<? extends HierarchicalStreamDriver> jsonDriverClass) {
        this.jsonDriverClass = jsonDriverClass;
    }

    public void setXmlDriverClass(Class<? extends HierarchicalStreamDriver> xmlDriverClass) {
        this.xmlDriverClass = xmlDriverClass;
    }

    public void setXstream(XStream xstream) {
        this.xstream = xstream;
    }

    public void write(Writer writer) throws IOException {
        if (this.representation != null) {
            this.representation.write(writer);
        } else if (this.object != null) {
            CharacterSet charSet;
            CharacterSet characterSet = charSet = this.getCharacterSet() == null ? CharacterSet.ISO_8859_1 : this.getCharacterSet();
            if (!MediaType.APPLICATION_JSON.isCompatible((Metadata)this.getMediaType())) {
                writer.append("<?xml version=\"1.0\" encoding=\"" + charSet.getName() + "\" ?>\n");
            }
            this.getXstream().toXML(this.object, writer);
        }
    }
}

