/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.sip;

import junit.framework.TestCase;
import org.junit.Test;
import org.restlet.data.Parameter;
import org.restlet.ext.sip.Availability;
import org.restlet.ext.sip.internal.AvailabilityReader;

public class AvailabilityTestCase
extends TestCase {
    @Test
    public void testParsing() throws Exception {
        String str = "18000;duration=3600;tag=hyh8";
        AvailabilityReader r = new AvailabilityReader(str);
        Availability a = r.readValue();
        AvailabilityTestCase.assertEquals((int)18000, (int)a.getDelay());
        AvailabilityTestCase.assertEquals((int)3600, (int)a.getDuration());
        AvailabilityTestCase.assertNull((Object)a.getComment());
        AvailabilityTestCase.assertEquals((int)1, (int)a.getParameters().size());
        Parameter parameter = (Parameter)a.getParameters().get(0);
        AvailabilityTestCase.assertEquals((String)"tag", (String)parameter.getName());
        AvailabilityTestCase.assertEquals((String)"hyh8", (String)parameter.getValue());
        str = "120 (I'm in a meeting)";
        r = new AvailabilityReader(str);
        a = r.readValue();
        AvailabilityTestCase.assertEquals((int)120, (int)a.getDelay());
        AvailabilityTestCase.assertEquals((int)0, (int)a.getDuration());
        AvailabilityTestCase.assertEquals((String)"I'm in a meeting", (String)a.getComment());
        AvailabilityTestCase.assertEquals((int)0, (int)a.getParameters().size());
    }

    @Test
    public void testWriting() {
    }
}

